/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.submitters;

import java.util.Date;
import java.util.List;
import jenkins.plugins.elastest.json.ExternalJob;
import jenkins.plugins.elastest.json.Trace;
import jenkins.plugins.elastest.submitters.ElasTestSubmitter;
import org.apache.commons.lang.StringUtils;

abstract class AbstractElasTestSubmitter
implements ElasTestSubmitter {
    protected final String host;
    protected final int port;
    protected final String key;
    protected final String username;
    protected final String password;

    AbstractElasTestSubmitter(String host, int port, String key, String username, String password) {
        this.host = host;
        this.port = port;
        this.key = key;
        this.username = username;
        this.password = password;
        if (StringUtils.isBlank((String)host)) {
            throw new IllegalArgumentException("host name is required");
        }
    }

    @Override
    public String buildPayload(List<String> logLines, ExternalJob externalJob) {
        Trace trace = new Trace("test", externalJob.gettJobExecId().toString(), "default_log", logLines.get(0), new Date().toString());
        String payload = trace.toJSON();
        return payload;
    }

    @Override
    public String buildPayload(String message, ExternalJob externalJob) {
        Trace trace = new Trace("test", externalJob.gettJobExecId().toString(), "default_log", message, new Date().toString());
        String payload = trace.toJSON();
        return payload;
    }

    @Override
    public String getDescription() {
        return this.host + ":" + this.port;
    }
}

