/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.pipeline;

import com.google.common.util.concurrent.FutureCallback;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.plugins.elastest.ConsoleLogFilterImpl;
import jenkins.plugins.elastest.ElasTestService;
import jenkins.plugins.elastest.ElasTestWriter;
import jenkins.plugins.elastest.action.ElasTestItemMenuAction;
import jenkins.plugins.elastest.docker.DockerCommandExecutor;
import jenkins.plugins.elastest.docker.DockerService;
import jenkins.plugins.elastest.json.ElasTestBuild;
import jenkins.plugins.elastest.json.ExternalJob;
import jenkins.plugins.elastest.pipeline.ElasTestStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasTestStepExecutionImpl
extends AbstractStepExecutionImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ElasTestStepExecutionImpl.class);
    private static final long serialVersionUID = 1L;
    private static final String ETM_CONTAINER_NAME = "elastest_etm_1";
    private ElasTestService elasTestService;
    private DockerService dockerService;
    private ElasTestWriter writer;
    private DockerCommandExecutor dockerCommandExecutor;
    @Inject
    transient ElasTestStep elasTestStep;

    public boolean start() throws Exception {
        System.setProperty("hudson.model.ParametersAction.keepUndefinedParameters", "true");
        this.elasTestService = ElasTestService.getInstance();
        StepContext context = this.getContext();
        Run build = (Run)context.get(Run.class);
        ElasTestBuild elasTestBuild = null;
        LOG.info("[elastest-plugin]: Working on build {}", (Object)build.getFullDisplayName());
        try {
            elasTestBuild = new ElasTestBuild();
            elasTestBuild.setWorkspace((FilePath)context.get(FilePath.class));
            this.elasTestService.asociateToElasTestTJob(build, this.elasTestStep, elasTestBuild);
        }
        catch (Exception e) {
            LOG.error("[elastest-plugin]: Error trying to bind the build with a TJob.");
            e.printStackTrace();
            throw e;
        }
        try {
            ElasTestItemMenuAction.addActionToMenu(build);
            while (!elasTestBuild.getExternalJob().isReady()) {
                elasTestBuild.setExternalJob(this.elasTestService.isReadyTJobForExternalExecution(elasTestBuild.getExternalJob()));
                try {
                    if (elasTestBuild.getExternalJob().isReady()) continue;
                    Thread.sleep(500L);
                }
                catch (IllegalArgumentException | InterruptedException ie) {
                    LOG.warn("[elastest-plugin]: {}", (Object)ie.getMessage());
                }
            }
            this.writer = new ElasTestWriter(build, null, this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()));
            elasTestBuild.setWriter(this.writer);
            this.addEnvVars(build);
            if (this.elasTestStep.isMonitoring()) {
                this.dockerService = DockerService.getDockerService("unix:///var/run/docker.sock");
                this.dockerCommandExecutor = new DockerCommandExecutor(null, this.dockerService);
                this.startMonitoringContainers(this.elasTestStep.envVars, elasTestBuild, ((FilePath)context.get(FilePath.class)).getChannel());
            }
        }
        catch (Exception e) {
            LOG.error("[elastest-plugin]: Error preparing Job execution.");
            e.printStackTrace();
            throw e;
        }
        ExpanderImpl expanderImpl = new ExpanderImpl();
        expanderImpl.setOverrides((Map<String, String>)this.elasTestStep.envVars);
        expanderImpl.expand((EnvVars)this.getContext().get(EnvVars.class));
        String agentIdOrNull = this.elasTestService.manageEIMIfNecessary(build, elasTestBuild.getEnvVars());
        elasTestBuild.setEimAgentId(agentIdOrNull);
        context.newBodyInvoker().withContext((Object)this.createConsoleLogFilter(context, build)).withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)expanderImpl)).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
        return false;
    }

    private ConsoleLogFilter createConsoleLogFilter(StepContext context, Run<?, ?> build) throws IOException, InterruptedException {
        LOG.debug("[elastest-plugin]: Creating console log filter.");
        ConsoleLogFilterImpl logFilterImpl = new ConsoleLogFilterImpl(build, this.writer);
        return logFilterImpl;
    }

    private void addEnvVars(Run<?, ?> build) {
        ExternalJob externalJob = this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName());
        this.elasTestStep.envVars.putAll(externalJob.getEnvVars() != null ? externalJob.getEnvVars() : new HashMap());
    }

    private void startMonitoringContainers(EnvVars envVars, ElasTestBuild elasTestBuild, VirtualChannel channel) throws IOException, RuntimeException, InterruptedException {
        LOG.info("[elastest-plugin]: Start container monitoring");
        String fileBeatImage = "elastest/etm-filebeat:latest";
        String dockBeatImage = "elastest/etm-dockbeat:latest";
        String logstashHost = "LOGSTASHHOST=" + (!((String)envVars.get((Object)"ET_MON_LSBEATS_HOST")).trim().equals("localhost") ? (String)envVars.get((Object)"ET_MON_LSBEATS_HOST") : this.dockerService.getGatewayFromContainer(ETM_CONTAINER_NAME));
        String logstashPort = "LOGSTASHPORT=" + (String)envVars.get((Object)"ET_MON_INTERNAL_LSBEATS_PORT");
        String etMonLsbeatsHost = "ET_MON_LSBEATS_HOST=" + (String)envVars.get((Object)"ET_MON_LSBEATS_HOST");
        String etMonLsbeatsPort = "ET_MON_LSBEATS_PORT=" + (String)envVars.get((Object)"ET_MON_LSBEATS_PORT");
        String etMonContainersName = "ET_MON_CONTAINERS_NAME=^(" + (String)envVars.get((Object)"ET_SUT_CONTAINER_NAME") + ")(_)?(\\d*)(.*)?";
        if (this.isRemoteElasTest(channel)) {
            this.dockerCommandExecutor.setCommand("docker", "run", "-d", "--name", "fileBeat_" + (String)envVars.get((Object)"ET_SUT_CONTAINER_NAME"), "-e", etMonLsbeatsHost, "-e", etMonLsbeatsPort, "-e", etMonContainersName, "-v", "/var/run/docker.sock:/var/run/docker.sock", "-v", "/var/lib/docker/containers:/var/lib/docker/containers", fileBeatImage);
            LOG.info("[elastest-jenkins]: Built command to execute {}", (Object)Arrays.toString(this.dockerCommandExecutor.getCommand()));
            elasTestBuild.getContainers().add(this.processDockeCommandOutput((String)channel.call((Callable)this.dockerCommandExecutor)));
        }
        this.dockerCommandExecutor.setCommand("docker", "run", "-d", "--name", "dockBeat_" + (String)envVars.get((Object)"ET_SUT_CONTAINER_NAME"), "-e", logstashHost, "-e", logstashPort, "-v", "/var/run/docker.sock:/var/run/docker.sock", "-v", "/var/lib/docker/containers:/var/lib/docker/containers", dockBeatImage);
        LOG.info("[elastest-jenkins]: Built command to execute {}", (Object)Arrays.toString(this.dockerCommandExecutor.getCommand()));
        elasTestBuild.getContainers().add(this.processDockeCommandOutput((String)channel.call((Callable)this.dockerCommandExecutor)));
    }

    private String processDockeCommandOutput(String output) {
        if (output.contains(":")) {
            output = output.substring(output.lastIndexOf(":latest") + 7);
        }
        return output;
    }

    private boolean isRemoteElasTest(VirtualChannel channel) throws IOException, RuntimeException, InterruptedException {
        LOG.info("[elastest-plugin]: Checking if ElasTest is running locally.");
        boolean result = true;
        String etContainername = ETM_CONTAINER_NAME;
        String errorMessage = "No such object: " + etContainername;
        this.dockerCommandExecutor.setCommand("docker", "inspect", "--format=\\\"{{.Name}}\\\"", etContainername);
        result = ((String)channel.call((Callable)this.dockerCommandExecutor)).contains(errorMessage);
        LOG.debug("[elastest-plugin]: Result of the inspect command: {}", (Object)result);
        return result;
    }

    public void stop(@Nonnull Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private Map<String, String> overrides = new HashMap<String, String>();

        private ExpanderImpl() {
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.overrides);
        }

        public void setOverrides(Map<String, String> overrides) {
            this.overrides = overrides;
        }
    }
}

