/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.model.Run;
import hudson.tasks.LogRotator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import jenkins.model.BuildDiscarder;
import jenkins.plugins.elastest.EIMManager;
import jenkins.plugins.elastest.ElasTestBuildWrapper;
import jenkins.plugins.elastest.ElasTestInstallation;
import jenkins.plugins.elastest.json.ElasTestBuild;
import jenkins.plugins.elastest.json.ExternalJob;
import jenkins.plugins.elastest.json.Sut;
import jenkins.plugins.elastest.json.TestSupportServices;
import jenkins.plugins.elastest.pipeline.ElasTestStep;
import jenkins.plugins.elastest.utils.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasTestService
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ElasTestService.class);
    private static ElasTestService instance;
    private static final String EIM_API_KEY = "ET_EIM_API";
    private static final String EIM_PACKETLOSS_KEY = "ET_EIM_CONTROLLABILLITY_PACKETLOSS";
    private static final String EIM_CPUBURST_KEY = "ET_EIM_CONTROLLABILLITY_CPUBURST";
    private HashMap<String, ElasTestBuild> elasTestBuilds = new HashMap();
    private Map<String, String> tSServicesCatalog;
    private String elasTestTJobApiUrl;
    private String elasTestVersionApiUrl;
    private String elasTestUrl;
    private transient Client client = ClientBuilder.newClient();
    protected boolean witAuthentication = false;
    private Authenticator authenticator = new Authenticator(null, null);

    public ElasTestService() {
        this.setNewConfiguration();
    }

    private void setNewConfiguration() {
        this.elasTestUrl = ElasTestInstallation.getLogstashDescriptor().elasTestUrl;
        this.elasTestTJobApiUrl = this.elasTestUrl + "/api/external/tjob";
        this.elasTestVersionApiUrl = "/api/external/elastest/version";
        String name = ElasTestInstallation.getLogstashDescriptor().username;
        String password = ElasTestInstallation.getLogstashDescriptor().password;
        if (name != null && !name.equals("") && password != null && !password.equals("")) {
            this.witAuthentication = true;
            this.authenticator.setCredentials(name, password);
            if (this.client.getConfiguration().isRegistered(Authenticator.class)) {
                LOG.info("[elastest-plugin]: There is an Authenticator registered");
                LOG.info("[elastest-plugin]: Setting new credentials");
            } else {
                this.client = (Client)this.client.register((Object)this.authenticator);
            }
            LOG.info("[elastest-plugin]: Now access to ElasTest is with username and password.");
        } else {
            LOG.info("[elastest-plugin]: Removing credentials");
            this.witAuthentication = false;
            this.authenticator.setCredentials(null, null);
            LOG.info("[elastest-plugin]: Now access to ElasTest is without username and password.");
        }
        this.tSServicesCatalog = this.loadTSSCatalog();
    }

    private Map<String, String> loadTSSCatalog() {
        HashMap<String, String> tSSCatalog = new HashMap<String, String>();
        tSSCatalog.put("EUS", "29216b91-497c-43b7-a5c4-6613f13fa0e9");
        tSSCatalog.put("EBS", "a1920b13-7d11-4ebc-a732-f86a108ea49c");
        tSSCatalog.put("EMS", "bab3ae67-8c1d-46ec-a940-94183a443825");
        tSSCatalog.put("ESS", "af7947d9-258b-4dd1-b1ca-17450db25ef7");
        tSSCatalog.put("EDS", "fe5e0531-b470-441f-9c69-721c2b4875f2");
        return tSSCatalog;
    }

    public void asociateToElasTestTJob(Run<?, ?> build, ElasTestBuildWrapper elasTestBuilder, ElasTestBuild elasTestBuild) throws Exception {
        LOG.info("[elastest-plugin]: Associate a Job to a TJob {}", (Object)build.getParent().getDisplayName());
        ExternalJob externalJob = new ExternalJob(build.getParent().getDisplayName());
        if (elasTestBuilder.isEus()) {
            ArrayList<String> tss = new ArrayList<String>();
            tss.add("EUS");
            externalJob.setTSServices(this.prepareTSSToSendET(tss));
        }
        externalJob = this.asociateToElasTestTJob(externalJob);
        elasTestBuild.setExternalJob(externalJob);
        this.elasTestBuilds.put(build.getFullDisplayName(), elasTestBuild);
    }

    public void asociateToElasTestTJob(Run<?, ?> build, ElasTestStep elasTestStep, ElasTestBuild elasTestBuild) throws Exception {
        ExternalJob externalJob = new ExternalJob(build.getParent().getDisplayName());
        Long maxBuilds = this.getMaxBuildsToKeep(build);
        if (maxBuilds != null && maxBuilds >= 0L) {
            LOG.debug("Max builds to keep: {}", (Object)maxBuilds);
            externalJob.setMaxExecutions(maxBuilds);
        } else {
            LOG.debug("Max builds to keep: Using the default value set by elastest");
        }
        externalJob.setTSServices(this.prepareTSSToSendET(elasTestStep.getTss()));
        LOG.debug("[elastest-plugin]: TestResutlPatter: " + elasTestStep.getSurefireReportsPattern());
        externalJob.setTestResultFilePattern(elasTestStep.getSurefireReportsPattern() != null && !elasTestStep.getSurefireReportsPattern().isEmpty() ? elasTestStep.getSurefireReportsPattern() : null);
        externalJob.setSut(elasTestStep.getSut() != -1L ? new Sut(elasTestStep.getSut(), elasTestStep.getSutParams()) : null);
        externalJob.setFromIntegratedJenkins(elasTestStep.envVars.get((Object)"INTEGRATED_JENKINS") != null && ((String)elasTestStep.envVars.get((Object)"INTEGRATED_JENKINS")).equals(Boolean.TRUE.toString()) && this.elasTestUrl.equals("http://etm:8091"));
        LOG.info("[elastest-plugin]: Build URL: {}", elasTestStep.envVars.get((Object)"BUILD_URL"));
        LOG.info("[elastest-plugin]: Job URL: {}", elasTestStep.envVars.get((Object)"JOB_URL"));
        externalJob.setBuildUrl((String)elasTestStep.envVars.get((Object)"BUILD_URL"));
        externalJob.setJobUrl((String)elasTestStep.envVars.get((Object)"JOB_URL"));
        externalJob.setProject(!elasTestStep.getProject().isEmpty() ? elasTestStep.getProject() : null);
        externalJob = this.asociateToElasTestTJob(externalJob);
        elasTestBuild.setExternalJob(externalJob);
        elasTestBuild.setEnvVars(elasTestStep.envVars);
        LOG.info("[elastest-plugin]: Job associated with a TJob");
        this.elasTestBuilds.put(build.getFullDisplayName(), elasTestBuild);
        LOG.info("[elastest-plugin]: ElasTestBuild saved {} ", (Object)elasTestBuild);
    }

    public ExternalJob asociateToElasTestTJob(ExternalJob externalJob) throws Exception {
        int maxAttempts = 5;
        externalJob.settJobExecId(0L);
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            LOG.debug("[elastest-plugin]: associating with a TJob, attempt {}", (Object)attempt);
            try {
                if (attempt > 0) {
                    Thread.sleep(500L);
                }
                externalJob = this.createTJobOnElasTest(externalJob);
                break;
            }
            catch (IllegalArgumentException | InterruptedException ie) {
                LOG.warn("[elastest-plugin]: {}", (Object)ie.getMessage());
                continue;
            }
            catch (Exception e) {
                LOG.error("[elastest-plugin]: Error during reattempt -> {}", (Object)e.getMessage());
                if (attempt != maxAttempts - 1) continue;
                throw e;
            }
        }
        externalJob.setExecutionUrl(externalJob.getExecutionUrl());
        externalJob.setLogAnalyzerUrl(externalJob.getLogAnalyzerUrl());
        LOG.info("Content of the external Job returned by ElasTest.");
        return externalJob;
    }

    private ExternalJob createTJobOnElasTest(ExternalJob externalJob) throws Exception {
        ObjectMapper objetMapper = new ObjectMapper();
        WebTarget webTarget = this.client.target(this.elasTestTJobApiUrl);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        Response response = null;
        try {
            response = invocationBuilder.post(Entity.entity((Object)externalJob.toJSON(), (String)"application/json"));
            externalJob = (ExternalJob)objetMapper.readValue((String)response.readEntity(String.class), ExternalJob.class);
            if (externalJob.getStatus() == ExternalJob.ExternalJobStatusEnum.ERROR) {
                throw new Exception(externalJob.getError());
            }
            LOG.debug("[elastest-plugin]: Body in association request: {}", (Object)externalJob.toJSON());
        }
        catch (Exception e) {
            LOG.error("[elastest-plugin]: Error trying to create a TJob {} in ElasTest: {}", (Object)externalJob.toJSON(), (Object)e.getMessage());
            LOG.error("[elastest-plugin]: Elastest endpoint -> {}", (Object)this.elasTestTJobApiUrl);
            e.printStackTrace();
            throw e;
        }
        return externalJob;
    }

    public ExternalJob isReadyTJobForExternalExecution(ExternalJob externalJob) throws Exception {
        ObjectMapper objetMapper = new ObjectMapper();
        WebTarget webTarget = this.client.target(this.elasTestTJobApiUrl).path(externalJob.gettJobExecId().toString());
        LOG.info("[elastest-plugin]: URL to check if a TJob is ready -> {}", (Object)webTarget.getUri().toString());
        Invocation.Builder invocationBuilder = webTarget.request().accept(new String[]{"application/json"});
        Response response = null;
        try {
            response = (Response)invocationBuilder.get(Response.class);
            externalJob = (ExternalJob)objetMapper.readValue((String)response.readEntity(String.class), ExternalJob.class);
            if (externalJob.getStatus() == ExternalJob.ExternalJobStatusEnum.ERROR) {
                throw new Exception(externalJob.getError());
            }
        }
        catch (Exception e) {
            LOG.error("[elastest-plugin]: Error cheking if the TJob is ready: {}", (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return externalJob;
    }

    public void finishElasTestTJobExecution(ExternalJob externalJob) {
        LOG.info("[elastest-plugin]: Sending finalization message.");
        WebTarget webTarget = this.client.target(this.elasTestTJobApiUrl);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        try {
            invocationBuilder.put(Entity.entity((Object)externalJob.toJSON(), (String)"application/json"));
        }
        catch (Exception e) {
            LOG.error("[elastest-plugin]: Error sending the finalization message to ElasTest: {}", (Object)e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public String getElasTestVersion() {
        String result = "KO";
        WebTarget webTarget = this.client.target(this.elasTestUrl).path(this.elasTestVersionApiUrl);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"text/plain"});
        Response response = null;
        try {
            response = (Response)invocationBuilder.get(Response.class);
            result = (String)response.readEntity(String.class);
            LOG.info("[elastest-plugin]: ElasTest version installed: " + result);
        }
        catch (Exception uie) {
            LOG.error("[elastest-plugin]: Error invoking ElasTest.");
            result = "The connection to ElasTest could not be established.";
            throw uie;
        }
        return result;
    }

    public ExternalJob getExternalJobByBuildFullName(String buildFullName) {
        return this.elasTestBuilds.get(buildFullName).getExternalJob();
    }

    public HashMap<String, ElasTestBuild> getElasTestBuilds() {
        return this.elasTestBuilds;
    }

    public void removeExternalJobs(String buildId) {
        this.elasTestBuilds.remove(buildId);
    }

    public static synchronized ElasTestService getInstance() {
        if (instance == null) {
            instance = new ElasTestService();
        } else {
            instance.setNewConfiguration();
        }
        return instance;
    }

    private List<TestSupportServices> prepareTSSToSendET(List<String> tSServices) {
        ArrayList<TestSupportServices> eTTSServices = new ArrayList<TestSupportServices>();
        for (String tSSName : tSServices) {
            if (!this.tSServicesCatalog.containsKey(tSSName)) continue;
            TestSupportServices newTSService = new TestSupportServices(this.tSServicesCatalog.get(tSSName), tSSName, true);
            eTTSServices.add(newTSService);
        }
        return eTTSServices;
    }

    private Long getMaxBuildsToKeep(Run<?, ?> build) {
        BuildDiscarder buildDiscarder = build.getParent().getBuildDiscarder();
        if (buildDiscarder != null && buildDiscarder instanceof LogRotator) {
            return ((LogRotator)buildDiscarder).getNumToKeep();
        }
        return null;
    }

    public String manageEIMIfNecessary(Run<?, ?> build, EnvVars etBuildVars) {
        try {
            EnvVars buildVars = build.getEnvironment();
            String EIM_AGENTID_KEY = "ET_EIM_SUT_AGENT_ID";
            if (etBuildVars.containsKey((Object)EIM_API_KEY) && etBuildVars.containsKey((Object)EIM_AGENTID_KEY) && (buildVars.containsKey((Object)EIM_PACKETLOSS_KEY) || buildVars.containsKey((Object)EIM_CPUBURST_KEY))) {
                String eimApiUrl = (String)etBuildVars.get((Object)EIM_API_KEY);
                EIMManager eimManager = new EIMManager(eimApiUrl);
                String agentId = (String)etBuildVars.get((Object)EIM_AGENTID_KEY);
                if (buildVars.containsKey((Object)EIM_PACKETLOSS_KEY)) {
                    String packetLossValue = (String)buildVars.get((Object)EIM_PACKETLOSS_KEY);
                    LOG.info("Sending packet loss {} to agent {} through EIM at {}", new Object[]{packetLossValue, agentId, eimApiUrl});
                    eimManager.sendPacketLoss(agentId, packetLossValue);
                }
                if (buildVars.containsKey((Object)EIM_CPUBURST_KEY)) {
                    String cpuBurstValue = (String)buildVars.get((Object)EIM_CPUBURST_KEY);
                    LOG.info("Sending cpu burst {} to agent {} through EIM at {}", (Object)cpuBurstValue, (Object)eimApiUrl);
                    eimManager.sendCpuBurst(agentId, cpuBurstValue);
                }
                return agentId;
            }
        }
        catch (Exception e) {
            LOG.warn("[elastest-plugin] EIM manage: {}", (Object)e.getMessage());
        }
        return null;
    }

    public void manageEIMEndIfNecessary(Run<?, ?> build, EnvVars etBuildVars) {
        try {
            EnvVars buildVars = build.getEnvironment();
            String EIM_AGENTID_KEY = "ET_EIM_SUT_AGENT_ID";
            if (etBuildVars.containsKey((Object)EIM_API_KEY) && etBuildVars.containsKey((Object)EIM_AGENTID_KEY) && (buildVars.containsKey((Object)EIM_PACKETLOSS_KEY) || buildVars.containsKey((Object)EIM_CPUBURST_KEY))) {
                String eimApiUrl = (String)etBuildVars.get((Object)EIM_API_KEY);
                EIMManager eimManager = new EIMManager(eimApiUrl);
                String agentId = (String)etBuildVars.get((Object)EIM_AGENTID_KEY);
                if (buildVars.containsKey((Object)EIM_PACKETLOSS_KEY)) {
                    String packetLossValue = (String)buildVars.get((Object)EIM_PACKETLOSS_KEY);
                    LOG.info("Removing packet loss {} to agent {} through EIM at {}", new Object[]{packetLossValue, agentId, eimApiUrl});
                    eimManager.removePacketloss(agentId);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("[elastest-plugin] EIM end manage: {}", (Object)e.getMessage());
        }
    }
}

