/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import jenkins.plugins.elastest.ConsoleLogFilterImpl;
import jenkins.plugins.elastest.ElasTestService;
import jenkins.plugins.elastest.ElasTestWriter;
import jenkins.plugins.elastest.Messages;
import jenkins.plugins.elastest.action.ElasTestItemMenuAction;
import jenkins.plugins.elastest.json.ElasTestBuild;
import jenkins.plugins.elastest.json.ExternalJob;
import jenkins.tasks.SimpleBuildWrapper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasTestBuildWrapper
extends SimpleBuildWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ElasTestService elasTestService;
    private boolean eus;

    @DataBoundConstructor
    public ElasTestBuildWrapper() {
        LOG.debug("[elastest-plugin]: ElasTestBuildWrapper Constructor");
    }

    public boolean isEus() {
        return this.eus;
    }

    @DataBoundSetter
    public void setEus(boolean eus) {
        this.eus = eus;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        LOG.debug("[elastest-plugin]: ElasTestBuildWrapper SetUp");
        ExternalJob externalJob = this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName());
        if (externalJob.getResult() != 1) {
            ElasTestItemMenuAction.addActionToMenu(build);
            ElasTestBuild elasTestBuild = this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName());
            elasTestBuild.setWorkspace(workspace);
            while (!elasTestBuild.getExternalJob().isReady()) {
                try {
                    elasTestBuild.setExternalJob(this.elasTestService.isReadyTJobForExternalExecution(externalJob));
                }
                catch (Exception e) {
                    LOG.debug("[elastest-plugin]: Error checking the status of the TJob.");
                    e.printStackTrace();
                    throw new InterruptedException();
                }
            }
            if (this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()).getEnvVars() != null) {
                for (Map.Entry<String, String> entry : this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()).getEnvVars().entrySet()) {
                    context.env(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public ConsoleLogFilter createLoggerDecorator(Run<?, ?> build) {
        ElasTestWriter elasTestWriter;
        LOG.debug("[elastest-plugin]: ElasTestBuildWrapper CreateLoggerDecorator");
        this.elasTestService = ElasTestService.getInstance();
        ElasTestBuild elasTestBuild = new ElasTestBuild();
        try {
            this.elasTestService.asociateToElasTestTJob(build, this, elasTestBuild);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()).setResult(1);
        }
        if (this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).getWriter() != null) {
            LOG.debug("[elastest-plugin]: Getting the existing writer");
            elasTestWriter = this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).getWriter();
        } else {
            LOG.debug("[elastest-plugin]: Creating a new writer");
            elasTestWriter = new ElasTestWriter(build, null, this.elasTestService.getExternalJobByBuildFullName(build.getFullDisplayName()));
            this.elasTestService.getElasTestBuilds().get(build.getFullDisplayName()).setWriter(elasTestWriter);
        }
        return new ConsoleLogFilterImpl(build, elasTestWriter);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    ElasTestWriter getElasTestWriter(Run<?, ?> build, OutputStream errorStream, ExternalJob externalJob) {
        return new ElasTestWriter(build, null, externalJob);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(ElasTestBuildWrapper.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.DisplayName();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

