/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public final class WindowsBatchScript
extends FileMonitoringTask {
    private final String script;
    private boolean capturingOutput;

    @DataBoundConstructor
    public WindowsBatchScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    @Override
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="%n from master might be \\n")
    protected FileMonitoringTask.FileMonitoringController doLaunch(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars) throws IOException, InterruptedException {
        if (launcher.isUnix()) {
            throw new IOException("Batch scripts can only be run on Windows nodes");
        }
        BatchController c = new BatchController(ws);
        String cmd = this.capturingOutput ? String.format("@echo off \r\ncmd /c \"\"%s\"\" > \"%s\" 2> \"%s\"\r\necho %%ERRORLEVEL%% > \"%s\"\r\n", WindowsBatchScript.quote(c.getBatchFile2(ws)), WindowsBatchScript.quote(c.getOutputFile(ws)), WindowsBatchScript.quote(c.getLogFile(ws)), WindowsBatchScript.quote(c.getResultFile(ws))) : String.format("@echo off \r\ncmd /c \"\"%s\"\" > \"%s\" 2>&1\r\necho %%ERRORLEVEL%% > \"%s\"\r\n", WindowsBatchScript.quote(c.getBatchFile2(ws)), WindowsBatchScript.quote(c.getLogFile(ws)), WindowsBatchScript.quote(c.getResultFile(ws)));
        c.getBatchFile1(ws).write(cmd, "UTF-8");
        c.getBatchFile2(ws).write(this.script, "UTF-8");
        Launcher.ProcStarter ps = launcher.launch().cmds(new String[]{"cmd", "/c", "\"\"" + c.getBatchFile1(ws) + "\"\""}).envs(WindowsBatchScript.escape(envVars)).pwd(ws).quiet(true);
        ps.readStdout().readStderr();
        ps.start();
        return c;
    }

    private static String quote(FilePath f) {
        return f.getRemote().replace("%", "%%");
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.WindowsBatchScript_windows_batch();
        }
    }

    private static final class BatchController
    extends FileMonitoringTask.FileMonitoringController {
        private static final long serialVersionUID = 1L;

        private BatchController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getBatchFile1(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("jenkins-wrap.bat");
        }

        public FilePath getBatchFile2(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("jenkins-main.bat");
        }
    }
}

