/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask.executors;

import hudson.Extension;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.executors.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface ContinuedTask
extends Queue.Task {
    public boolean isContinued();

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class Scheduler
    extends QueueTaskDispatcher {
        private static final Logger LOGGER = Logger.getLogger(ContinuedTask.class.getName());

        private static boolean isContinued(Queue.Task task) {
            return task instanceof ContinuedTask && ((ContinuedTask)task).isContinued();
        }

        public CauseOfBlockage canTake(Node node, Queue.BuildableItem item) {
            if (Scheduler.isContinued(item.task)) {
                LOGGER.log(Level.FINER, "{0} is a continued task, so we are not blocking it", item.task);
                return null;
            }
            for (Queue.BuildableItem other : Queue.getInstance().getBuildableItems()) {
                if (Scheduler.isContinued(other.task)) {
                    Label label = other.task.getAssignedLabel();
                    if (label == null || label.matches(node)) {
                        LOGGER.log(Level.FINE, "blocking {0} in favor of {1}", new Object[]{item.task, other.task});
                        return new HoldOnPlease(other.task);
                    }
                    LOGGER.log(Level.FINER, "{0}\u2019s label {1} does not match {2}", new Object[]{other.task, label, node});
                    continue;
                }
                LOGGER.log(Level.FINER, "{0} is not continued, so it would not block {1}", new Object[]{other.task, item.task});
            }
            LOGGER.log(Level.FINER, "no reason to block {0}", item.task);
            return null;
        }

        private static final class HoldOnPlease
        extends CauseOfBlockage {
            private final Queue.Task task;

            HoldOnPlease(Queue.Task task) {
                this.task = task;
            }

            public String getShortDescription() {
                return Messages.ContinuedTask__should_be_allowed_to_run_first(this.task.getFullDisplayName());
            }
        }
    }
}

