/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Platform;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.durabletask.DurableTaskDescriptor;
import org.jenkinsci.plugins.durabletask.FileMonitoringTask;
import org.jenkinsci.plugins.durabletask.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BourneShellScript
extends FileMonitoringTask {
    private static final Logger LOGGER = Logger.getLogger(BourneShellScript.class.getName());
    private static int NOVEL_WORKSPACE_DIAGNOSTICS_COUNT = Integer.getInteger(BourneShellScript.class.getName() + ".NOVEL_WORKSPACE_DIAGNOSTICS_COUNT", 10);
    private static int HEARTBEAT_CHECK_INTERVAL = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_CHECK_INTERVAL", 15);
    private static int HEARTBEAT_MINIMUM_DELTA = Integer.getInteger(BourneShellScript.class.getName() + ".HEARTBEAT_MINIMUM_DELTA", 2);
    @Nonnull
    private final String script;
    private boolean capturingOutput;
    private static final Map<FilePath, Integer> encounteredPaths = new WeakHashMap<FilePath, Integer>();

    @DataBoundConstructor
    public BourneShellScript(String script) {
        this.script = Util.fixNull((String)script);
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public void captureOutput() {
        this.capturingOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileMonitoringTask.FileMonitoringController launchWithCookie(FilePath ws, Launcher launcher, TaskListener listener, EnvVars envVars, String cookieVariable, String cookieValue) throws IOException, InterruptedException {
        boolean novel;
        if (this.script.isEmpty()) {
            listener.getLogger().println("Warning: was asked to run an empty script");
        }
        ShellController c = new ShellController(ws);
        FilePath shf = c.getScriptFile(ws);
        String s = this.script;
        Jenkins jenkins = Jenkins.getInstance();
        if (!s.startsWith("#!") && jenkins != null) {
            String defaultShell = ((Shell.DescriptorImpl)jenkins.getInjector().getInstance(Shell.DescriptorImpl.class)).getShellOrDefault(ws.getChannel());
            s = "#!" + defaultShell + " -xe\n" + s;
        }
        shf.write(s, "UTF-8");
        shf.chmod(493);
        String scriptPath = shf.getRemote();
        ArrayList<String> args = new ArrayList<String>();
        OsType os = (OsType)((Object)ws.act((Callable)new getOsType()));
        if (os != OsType.DARWIN) {
            args.add("nohup");
        }
        if (os == OsType.WINDOWS) {
            scriptPath = scriptPath.replace("\\", "/");
        }
        envVars.put(cookieVariable, "please-do-not-kill-me");
        FilePath logFile = c.getLogFile(ws);
        FilePath resultFile = c.getResultFile(ws);
        FilePath controlDir = c.controlDir(ws);
        String cmd = this.capturingOutput ? String.format("pid=$$; { while ps -o pid | grep -q \"^\\s*$pid$\" && [ -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc '%s' > '%s' 2> '%s'; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", controlDir, resultFile, logFile, cookieValue, cookieVariable, scriptPath, c.getOutputFile(ws), logFile, resultFile, resultFile, resultFile) : String.format("pid=$$; { while ps -o pid | grep -q \"^\\s*$pid$\" && [ -d '%s' -a \\! -f '%s' ]; do touch '%s'; sleep 3; done } & jsc=%s; %s=$jsc '%s' > '%s' 2>&1; echo $? > '%s.tmp'; mv '%s.tmp' '%s'; wait", controlDir, resultFile, logFile, cookieValue, cookieVariable, scriptPath, logFile, resultFile, resultFile, resultFile);
        cmd = cmd.replace("$", "$$");
        args.addAll(Arrays.asList("sh", "-c", cmd));
        LOGGER.log(Level.FINE, "launching {0}", args);
        Launcher.ProcStarter ps = launcher.launch().cmds(args).envs(BourneShellScript.escape(envVars)).pwd(ws).quiet(true);
        listener.getLogger().println("[" + ws.getRemote().replaceFirst("^.+/", "") + "] Running shell script");
        Map<FilePath, Integer> map = encounteredPaths;
        synchronized (map) {
            Integer cnt = encounteredPaths.get(ws);
            if (cnt == null) {
                cnt = 0;
            }
            novel = cnt < NOVEL_WORKSPACE_DIAGNOSTICS_COUNT;
            encounteredPaths.put(ws, cnt + 1);
        }
        if (novel) {
            ps.stdout(listener);
        } else {
            ps.readStdout().readStderr();
        }
        ps.start();
        return c;
    }

    private static final class getOsType
    extends MasterToSlaveCallable<OsType, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private getOsType() {
        }

        public OsType call() throws RuntimeException {
            if (Platform.isDarwin()) {
                return OsType.DARWIN;
            }
            if (Platform.current() == Platform.WINDOWS) {
                return OsType.WINDOWS;
            }
            return OsType.UNIX;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DurableTaskDescriptor {
        public String getDisplayName() {
            return Messages.BourneShellScript_bourne_shell();
        }
    }

    static final class ShellController
    extends FileMonitoringTask.FileMonitoringController {
        private transient long lastCheck;
        private transient long checkedTimestamp;
        private static final long serialVersionUID = 1L;

        private ShellController(FilePath ws) throws IOException, InterruptedException {
            super(ws);
        }

        public FilePath getScriptFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("script.sh");
        }

        private FilePath pidFile(FilePath ws) throws IOException, InterruptedException {
            return this.controlDir(ws).child("pid");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Integer exitStatus(FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            long currentTimestamp;
            block8: {
                block7: {
                    Integer status = super.exitStatus(workspace, launcher, listener);
                    if (status != null) {
                        LOGGER.log(Level.FINE, "found exit code {0} in {1}", new Object[]{status, this.controlDir});
                        return status;
                    }
                    long now = System.nanoTime();
                    if (this.lastCheck == 0L) {
                        LOGGER.log(Level.FINE, "starting check in {0}", this.controlDir);
                        this.lastCheck = now;
                        return null;
                    }
                    if (now <= this.lastCheck + TimeUnit.SECONDS.toNanos(HEARTBEAT_CHECK_INTERVAL)) return null;
                    this.lastCheck = now;
                    currentTimestamp = this.getLogFile(workspace).lastModified();
                    if (currentTimestamp == 0L) {
                        listener.getLogger().println("process apparently never started in " + this.controlDir);
                        return this.recordExitStatus(workspace, -2);
                    }
                    if (this.checkedTimestamp <= 0L) break block7;
                    if (currentTimestamp < this.checkedTimestamp) {
                        listener.getLogger().println("apparent clock skew in " + this.controlDir);
                        break block8;
                    } else if (currentTimestamp < this.checkedTimestamp + TimeUnit.SECONDS.toMillis(HEARTBEAT_MINIMUM_DELTA)) {
                        FilePath pidFile = this.pidFile(workspace);
                        if (!pidFile.exists()) {
                            listener.getLogger().println("wrapper script does not seem to be touching the log file in " + this.controlDir);
                            listener.getLogger().println("(JENKINS-48300: if on a laggy filesystem, consider -Dorg.jenkinsci.plugins.durabletask.BourneShellScript.HEARTBEAT_CHECK_INTERVAL=300)");
                            return this.recordExitStatus(workspace, -1);
                        }
                        listener.getLogger().println("still have " + pidFile + " so heartbeat checks unreliable; process may or may not be alive");
                    }
                    break block8;
                }
                LOGGER.log(Level.FINE, "seeing recent log file modifications in {0}", this.controlDir);
            }
            this.checkedTimestamp = currentTimestamp;
            return null;
        }

        private int recordExitStatus(FilePath workspace, int code) throws IOException, InterruptedException {
            this.getResultFile(workspace).write(Integer.toString(code), null);
            return code;
        }
    }

    private static enum OsType {
        DARWIN,
        UNIX,
        WINDOWS;

    }
}

