/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import com.sun.jna.Library;
import com.sun.jna.Native;
import hudson.Launcher;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;

final class ProcessLiveness {
    private static final Logger LOGGER = Logger.getLogger(ProcessLiveness.class.getName());
    private static final Map<Launcher, Boolean> workingLaunchers = Collections.synchronizedMap(new WeakHashMap());

    public static boolean isAlive(VirtualChannel channel, int pid, Launcher launcher) throws IOException, InterruptedException {
        Boolean working = workingLaunchers.get(launcher);
        if (working == null) {
            working = !ProcessLiveness._isAlive(channel, 9999, launcher);
            workingLaunchers.put(launcher, working);
            if (working.booleanValue()) {
                LOGGER.log(Level.FINE, "{0} on {1} appears to be working", new Object[]{launcher, channel});
            } else {
                LOGGER.log(Level.WARNING, "{0} on {1} does not seem able to determine whether processes are alive or not", new Object[]{launcher, channel});
            }
        }
        if (!working.booleanValue()) {
            return true;
        }
        return ProcessLiveness._isAlive(channel, pid, launcher);
    }

    private static boolean _isAlive(VirtualChannel channel, int pid, Launcher launcher) throws IOException, InterruptedException {
        if (launcher instanceof Launcher.LocalLauncher || launcher instanceof Launcher.RemoteLauncher) {
            try {
                boolean alive = (Boolean)channel.call((Callable)new Liveness(pid));
                LOGGER.log(Level.FINER, "{0} is alive? {1}", new Object[]{pid, alive});
                return alive;
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "cannot determine liveness of " + pid, x);
                return true;
            }
        }
        return launcher.launch().cmds(new String[]{"ps", "-o", "pid=", Integer.toString(pid)}).quiet(true).join() == 0;
    }

    private ProcessLiveness() {
    }

    private static interface LibC
    extends Library {
        public static final LibC INSTANCE = (LibC)Native.loadLibrary((String)"c", LibC.class);

        public int getpgid(int var1);
    }

    private static final class Liveness
    extends MasterToSlaveCallable<Boolean, RuntimeException> {
        private final int pid;

        Liveness(int pid) {
            this.pid = pid;
        }

        public Boolean call() throws RuntimeException {
            LibC libc = LibC.INSTANCE;
            if (libc.getpgid(0) == -1) {
                throw new IllegalStateException("getpgid does not seem to work on this platform");
            }
            return libc.getpgid(this.pid) != -1;
        }
    }
}

