/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.sources;

import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.sources.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.RelativePath;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class WildcardPathDeploySource
extends DeploySource {
    private static final Logger LOGGER = Logger.getLogger(WildcardPathDeploySource.class.getName());
    @NonNull
    private final String filePattern;

    @DataBoundConstructor
    public WildcardPathDeploySource(@CheckForNull String filePattern) {
        this.filePattern = StringUtils.isBlank((String)filePattern) ? "**/*.war" : filePattern;
    }

    @NonNull
    public String getFilePattern() {
        return this.filePattern;
    }

    @Override
    @CheckForNull
    public File getApplicationFile(@NonNull Run run) {
        File result = null;
        if (run.getArtifactsDir().isDirectory()) {
            FileSet fileSet = new FileSet();
            fileSet.setProject(new Project());
            fileSet.setDir(run.getArtifactsDir());
            fileSet.setIncludes(this.getFilePattern());
            try {
                String[] files = fileSet.getDirectoryScanner().getIncludedFiles();
                if (files.length > 0) {
                    result = new File(run.getArtifactsDir(), files[0]);
                }
            }
            catch (BuildException e) {
                LOGGER.log(Level.FINE, Messages.WildcardPathDeploySource_CouldNotListFromBuildArtifacts(this.getFilePattern(), run), e);
            }
        }
        return result;
    }

    @Override
    @CheckForNull
    public FilePath getApplicationFile(@NonNull FilePath workspace) {
        try {
            FilePath[] list = workspace.list(this.getFilePattern());
            return list != null && list.length > 0 ? list[0] : null;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, Messages.WildcardPathDeploySource_CouldNotListFromWorkspace(this.getFilePattern(), workspace), e);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINER, Messages.WildcardPathDeploySource_CouldNotListFromWorkspace(this.getFilePattern(), workspace), e);
        }
        return null;
    }

    @NonNull
    public String toString() {
        return this.filePattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardPathDeploySource that = (WildcardPathDeploySource)o;
        return this.filePattern.equals(that.filePattern);
    }

    public int hashCode() {
        return this.filePattern.hashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends DeploySourceDescriptor {
        public String getDisplayName() {
            return Messages.WildcardPathDeploySource_DisplayName();
        }

        @Override
        public boolean isSupported(@CheckForNull DeploySourceOrigin source) {
            return true;
        }

        @Override
        public boolean isApplicable(@CheckForNull Class<? extends AbstractProject> jobType) {
            return !DescriptorImpl.isMavenJob(jobType);
        }

        public FormValidation doCheckFilePattern(@QueryParameter @RelativePath(value="..") String fromWorkspace, @QueryParameter String targetDescriptorId, @QueryParameter String value) throws IOException, ServletException, InterruptedException {
            Run run;
            Job job;
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.warning((String)"You really should specify a pattern, otherwise '**/*.war' is assumed");
            }
            if (Boolean.valueOf(fromWorkspace).booleanValue() && (job = this.findJob()) != null && job instanceof AbstractProject) {
                FilePath someWorkspace = ((AbstractProject)job).getSomeWorkspace();
                if (someWorkspace == null) {
                    return FormValidation.warning((String)("The workspace is empty. Unable to validate '" + value + "'."));
                }
                FilePath[] filePaths = someWorkspace.list(value);
                if (filePaths.length > 1) {
                    return FormValidation.warning((String)("Multiple files in the workspace match '" + value + "'"));
                }
                if (filePaths.length == 1) {
                    return this.delegatePathValidationToTarget(value, targetDescriptorId, filePaths[0]);
                }
            }
            if ((run = this.findRun()) != null) {
                if (!run.getArtifactsDir().isDirectory()) {
                    return FormValidation.error((String)"There are no archived artifacts");
                }
                FileSet fileSet = new FileSet();
                fileSet.setProject(new Project());
                fileSet.setDir(run.getArtifactsDir());
                fileSet.setIncludes(value);
                int includedFilesCount = fileSet.getDirectoryScanner().getIncludedFilesCount();
                if (includedFilesCount > 1) {
                    return FormValidation.warning((String)("Multiple archived files match '" + value + "'"));
                }
                if (includedFilesCount == 1) {
                    return FormValidation.ok();
                }
            }
            return FormValidation.warning((String)("Could not find a file that matches '" + value + "'"));
        }

        @Override
        public DeploySource newInstance() {
            return new WildcardPathDeploySource("**/*.war");
        }
    }
}

