/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.sources;

import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.sources.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StaticSelectionDeploySource
extends DeploySource {
    private static final Logger LOGGER = Logger.getLogger(StaticSelectionDeploySource.class.getName());
    @NonNull
    private final String filePath;

    @DataBoundConstructor
    public StaticSelectionDeploySource(@CheckForNull String filePath) {
        this.filePath = StringUtils.trimToEmpty((String)filePath);
    }

    @NonNull
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    @CheckForNull
    public File getApplicationFile(@NonNull Run run) {
        if (run.getArtifactsDir().isDirectory()) {
            File file = new File(run.getArtifactsDir(), this.filePath);
            return file.exists() ? file : null;
        }
        return null;
    }

    @Override
    @NonNull
    public FilePath getApplicationFile(@NonNull FilePath workspace) {
        return workspace.child(this.filePath);
    }

    @NonNull
    public String toString() {
        return this.filePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticSelectionDeploySource that = (StaticSelectionDeploySource)o;
        return this.filePath.equals(that.filePath);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    @Extension
    public static class DescriptorImpl
    extends DeploySourceDescriptor {
        public String getDisplayName() {
            return Messages.StaticSelectionDeploySource_DisplayName();
        }

        @Override
        public boolean isSupported(@CheckForNull DeploySourceOrigin source) {
            return DeploySourceOrigin.RUN.equals((Object)source);
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return !DescriptorImpl.isMavenJob(jobType);
        }

        public FormValidation doCheckFilePath(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            Run run = this.findRun();
            if (run != null) {
                if (!run.getHasArtifacts()) {
                    return FormValidation.warning((String)("No artifacts were archived in the last successful run, unable to validate '" + value + "'"));
                }
                if (new File(run.getArtifactsDir(), value).isFile()) {
                    return FormValidation.ok();
                }
            }
            return FormValidation.warning((String)("Could not find a match for '" + value + "'"));
        }

        public ListBoxModel doFillFilePathItems() throws IOException, InterruptedException {
            Run run = this.findRun();
            ListBoxModel m = new ListBoxModel();
            if (run != null) {
                FileSet fileSet = new FileSet();
                fileSet.setProject(new Project());
                fileSet.setDir(run.getArtifactsDir());
                fileSet.setIncludes("**/*.war");
                for (String path : fileSet.getDirectoryScanner().getIncludedFiles()) {
                    m.add(path);
                }
            }
            return m;
        }

        @Override
        public DeploySource newInstance() {
            return new StaticSelectionDeploySource(null);
        }
    }
}

