/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.sources;

import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.sources.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MavenArtifactDeploySource
extends DeploySource {
    private static final Logger LOGGER = Logger.getLogger(MavenArtifactDeploySource.class.getName());
    public static final String DEFAULT_TYPE = "war";
    @CheckForNull
    private final String groupId;
    @CheckForNull
    private final String artifactId;
    @CheckForNull
    private final String classifier;
    @NonNull
    private final String type;

    @DataBoundConstructor
    public MavenArtifactDeploySource(@CheckForNull String groupId, @CheckForNull String artifactId, @CheckForNull String classifier, @CheckForNull String type) {
        this.groupId = MavenArtifactDeploySource.fixWildcard(Util.fixEmptyAndTrim((String)groupId));
        this.artifactId = MavenArtifactDeploySource.fixWildcard(Util.fixEmptyAndTrim((String)artifactId));
        this.classifier = Util.fixEmptyAndTrim((String)classifier);
        type = Util.fixEmptyAndTrim((String)type);
        this.type = type == null ? DEFAULT_TYPE : type;
    }

    @CheckForNull
    private static String fixWildcard(@CheckForNull String v) {
        return StringUtils.equals((String)"*", (String)v) ? null : v;
    }

    @CheckForNull
    public String getArtifactId() {
        return this.artifactId;
    }

    @CheckForNull
    public String getClassifier() {
        return this.classifier;
    }

    @CheckForNull
    public String getGroupId() {
        return this.groupId;
    }

    @NonNull
    public String getType() {
        return StringUtils.defaultString((String)this.type, (String)DEFAULT_TYPE);
    }

    @Override
    public FilePath getApplicationFile(@NonNull FilePath workspace) {
        return null;
    }

    @Override
    @CheckForNull
    public File getApplicationFile(@NonNull Run run) {
        List<Object> builds;
        if (run instanceof MavenBuild) {
            builds = Arrays.asList((MavenBuild)run);
        } else if (run instanceof MavenModuleSetBuild) {
            builds = new ArrayList();
            for (Object b : ((MavenModuleSetBuild)run).getModuleBuilds().values()) {
                builds.addAll((Collection<Object>)b);
            }
        } else {
            builds = Collections.emptyList();
        }
        ArrayList candidates = new ArrayList();
        for (MavenBuild mavenBuild : builds) {
            List records = mavenBuild.getActions(MavenArtifactRecord.class);
            if (records == null) continue;
            for (MavenArtifactRecord record : records) {
                MavenArtifact mainArtifact = record.mainArtifact;
                if (this.isCandidate(mainArtifact)) {
                    candidates.add(new SimpleEntry(mainArtifact, record));
                }
                if (this.isExactMatch(mainArtifact)) {
                    try {
                        return mainArtifact.getFile(record.getBuild());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                for (MavenArtifact artifact : record.attachedArtifacts) {
                    if (this.isCandidate(artifact)) {
                        candidates.add(new SimpleEntry(artifact, record));
                    }
                    if (!this.isExactMatch(artifact)) continue;
                    try {
                        return artifact.getFile(record.getBuild());
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
        if (candidates.size() == 1) {
            Map.Entry entry = (Map.Entry)candidates.get(0);
            MavenArtifact mavenArtifact = (MavenArtifact)entry.getKey();
            try {
                return mavenArtifact.getFile(((MavenArtifactRecord)entry.getValue()).getBuild());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isCandidate(MavenArtifact artifact) {
        if (!StringUtils.equals((String)this.getType(), (String)artifact.type)) {
            return false;
        }
        if (this.groupId != null && !StringUtils.equals((String)this.groupId, (String)artifact.groupId)) {
            return false;
        }
        if (this.artifactId != null && !StringUtils.equals((String)this.artifactId, (String)artifact.artifactId)) {
            return false;
        }
        return StringUtils.equals((String)Util.fixNull((String)this.classifier), (String)Util.fixNull((String)artifact.classifier));
    }

    private boolean isExactMatch(MavenArtifact artifact) {
        if (!StringUtils.equals((String)this.getType(), (String)artifact.type)) {
            return false;
        }
        if (this.groupId == null || !StringUtils.equals((String)this.groupId, (String)artifact.groupId)) {
            return false;
        }
        if (this.artifactId == null || !StringUtils.equals((String)this.artifactId, (String)artifact.artifactId)) {
            return false;
        }
        return StringUtils.equals((String)Util.fixNull((String)this.classifier), (String)Util.fixNull((String)artifact.classifier));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId == null ? "*" : this.groupId);
        sb.append(':');
        sb.append(this.artifactId == null ? "*" : this.artifactId);
        if (this.classifier != null) {
            sb.append(':');
            sb.append(this.classifier);
        }
        sb.append(':');
        sb.append(this.getType());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactDeploySource that = (MavenArtifactDeploySource)o;
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(that.classifier) : that.classifier != null) {
            return false;
        }
        if (this.groupId != null ? !this.groupId.equals(that.groupId) : that.groupId != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        private SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends DeploySourceDescriptor {
        private final WeakHashMap<Run, WeakReference<List<MavenBuild>>> buildCache = new WeakHashMap();

        public String getDisplayName() {
            return Messages.MavenArtifactDeploySource_DisplayName();
        }

        @Override
        public boolean isSupported(@CheckForNull DeploySourceOrigin source) {
            return DeploySourceOrigin.RUN.equals((Object)source);
        }

        @Override
        public boolean isApplicable(@CheckForNull Class<? extends AbstractProject> jobType) {
            return DescriptorImpl.isMavenJob(jobType);
        }

        public FormValidation doCheckGroupId(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            List<MavenBuild> builds = this.findMavenBuilds();
            if (builds.isEmpty()) {
                return FormValidation.ok();
            }
            for (MavenArtifact artifact : this.getAllArtifacts(builds)) {
                if (!StringUtils.equals((String)artifact.groupId, (String)value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Could not find a .war artifact with group id '" + value + "'"));
        }

        public ComboBoxModel doFillGroupIdItems() {
            TreeSet<String> result = new TreeSet<String>();
            for (MavenArtifact artifact : this.getAllArtifacts(this.findMavenBuilds())) {
                result.add(artifact.groupId);
            }
            return new ComboBoxModel(result);
        }

        public FormValidation doCheckArtifactId(@QueryParameter String groupId, @QueryParameter String value, @QueryParameter String classifier, @QueryParameter String type) throws IOException, ServletException {
            String defaultedType;
            List<MavenBuild> builds = this.findMavenBuilds();
            if (builds.isEmpty()) {
                return FormValidation.ok();
            }
            TreeSet<String> artifactIds = new TreeSet<String>();
            TreeSet<String> groupIds = new TreeSet<String>();
            TreeSet<String> classifiers = new TreeSet<String>();
            for (MavenArtifact artifact : this.getAllArtifacts(builds)) {
                if (!StringUtils.isBlank((String)value) && !StringUtils.equals((String)value, (String)artifact.artifactId)) continue;
                artifactIds.add(artifact.artifactId);
                if (!StringUtils.isBlank((String)groupId) && !StringUtils.equals((String)groupId, (String)artifact.groupId)) continue;
                groupIds.add(artifact.groupId);
                classifiers.add(Util.fixNull((String)artifact.classifier));
            }
            String string = defaultedType = StringUtils.isEmpty((String)type) ? MavenArtifactDeploySource.DEFAULT_TYPE : type;
            if (artifactIds.isEmpty()) {
                if (StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)groupId) && StringUtils.isEmpty((String)classifier) && StringUtils.isEmpty((String)type)) {
                    return FormValidation.ok();
                }
                if (StringUtils.isEmpty((String)groupId)) {
                    return FormValidation.warning((String)("Could not find a ." + defaultedType + " artifact with artifact id '" + value + "'"));
                }
                return FormValidation.warning((String)("Could not find a ." + defaultedType + " artifact with id '" + groupId + ":" + value + "'"));
            }
            if (StringUtils.isEmpty((String)value) && (artifactIds.size() > 1 || groupIds.size() > 1)) {
                return FormValidation.error((String)("There are multiple ." + defaultedType + " artifacts, you must identify the one you want to deploy"));
            }
            assert (artifactIds.size() == 1);
            if (StringUtils.isEmpty((String)groupId) && groupIds.size() > 1) {
                return FormValidation.error((String)("There are multiple ." + defaultedType + " artifacts with this artifact id that differ only in their group id, you should specify the group id of the artifact you want"));
            }
            if (classifiers.size() > 1) {
                if (StringUtils.isEmpty((String)classifier)) {
                    return FormValidation.warning((String)("There are multiple ." + defaultedType + " artifacts with this artifact id that differ only in their classifier."));
                }
                if (!classifiers.contains(classifier)) {
                    return FormValidation.warning((String)("Could not find a ." + defaultedType + " artifact with id '" + groupId + ":" + value + ":" + classifier + "'"));
                }
            }
            return FormValidation.ok();
        }

        public ComboBoxModel doFillArtifactIdItems(@QueryParameter String groupId) {
            TreeSet<String> result = new TreeSet<String>();
            for (MavenArtifact artifact : this.getAllArtifacts(this.findMavenBuilds())) {
                if (!StringUtils.isBlank((String)groupId) && !StringUtils.equals((String)groupId, (String)artifact.groupId)) continue;
                result.add(artifact.artifactId);
            }
            return new ComboBoxModel(result);
        }

        public ComboBoxModel doFillClassifierItems(@QueryParameter String groupId, @QueryParameter String artifactId) {
            TreeSet<String> result = new TreeSet<String>();
            for (MavenArtifact artifact : this.getAllArtifacts(this.findMavenBuilds())) {
                if (!StringUtils.isBlank((String)groupId) && !StringUtils.equals((String)groupId, (String)artifact.groupId) || !StringUtils.isBlank((String)artifactId) && !StringUtils.equals((String)artifactId, (String)artifact.artifactId)) continue;
                result.add(Util.fixNull((String)artifact.classifier));
            }
            return new ComboBoxModel(result);
        }

        public ComboBoxModel doFillTypeItems(@QueryParameter String groupId, @QueryParameter String artifactId, @QueryParameter String classifier) {
            TreeSet<String> result = new TreeSet<String>();
            for (MavenArtifact artifact : this.getAllArtifacts(this.findMavenBuilds())) {
                if ("pom".equals(artifact.type) || !StringUtils.isBlank((String)groupId) && !StringUtils.equals((String)groupId, (String)artifact.groupId) || !StringUtils.isBlank((String)artifactId) && !StringUtils.equals((String)artifactId, (String)artifact.artifactId) || !StringUtils.isBlank((String)classifier) && !StringUtils.equals((String)classifier, (String)artifact.classifier)) continue;
                result.add(Util.fixNull((String)artifact.type));
            }
            return new ComboBoxModel(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<MavenBuild> findMavenBuilds() {
            List<Object> builds;
            Run run = this.findRun();
            Object object = this.buildCache;
            synchronized (object) {
                WeakReference<List<MavenBuild>> reference = this.buildCache.get(run);
                if (reference != null && (builds = (List)reference.get()) != null) {
                    return builds;
                }
            }
            if (run instanceof MavenBuild) {
                builds = Arrays.asList((MavenBuild)run);
            } else if (run instanceof MavenModuleSetBuild) {
                builds = new ArrayList();
                for (List b : ((MavenModuleSetBuild)run).getModuleBuilds().values()) {
                    builds.addAll(b);
                }
            } else {
                builds = Collections.emptyList();
            }
            object = this.buildCache;
            synchronized (object) {
                this.buildCache.put(run, new WeakReference(builds));
            }
            return builds;
        }

        private Collection<MavenArtifact> getWebAppArtifacts(Collection<MavenBuild> builds) {
            ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
            for (MavenBuild build : builds) {
                List records = build.getActions(MavenArtifactRecord.class);
                if (records == null) continue;
                for (MavenArtifactRecord record : records) {
                    MavenArtifact mainArtifact = record.mainArtifact;
                    if (StringUtils.equals((String)MavenArtifactDeploySource.DEFAULT_TYPE, (String)mainArtifact.type)) {
                        result.add(mainArtifact);
                    }
                    for (MavenArtifact artifact : record.attachedArtifacts) {
                        if (!StringUtils.equals((String)MavenArtifactDeploySource.DEFAULT_TYPE, (String)artifact.type)) continue;
                        result.add(artifact);
                    }
                }
            }
            return result;
        }

        private Collection<MavenArtifact> getAllArtifacts(Collection<MavenBuild> builds) {
            ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
            for (MavenBuild build : builds) {
                result.addAll(this.getAllArtifacts(build));
            }
            return result;
        }

        private Collection<MavenArtifact> getAllArtifacts(MavenBuild build) {
            ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
            List records = build.getActions(MavenArtifactRecord.class);
            if (records != null) {
                for (MavenArtifactRecord record : records) {
                    MavenArtifact mainArtifact = record.mainArtifact;
                    result.add(mainArtifact);
                    for (MavenArtifact artifact : record.attachedArtifacts) {
                        result.add(artifact);
                    }
                }
            }
            return result;
        }

        @Override
        public DeploySource newInstance() {
            return new MavenArtifactDeploySource(null, null, null, MavenArtifactDeploySource.DEFAULT_TYPE);
        }
    }
}

