/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.sources;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public enum DeploySourceOrigin {
    WORKSPACE(1),
    RUN(0);

    private final int preference;

    private DeploySourceOrigin(int preference) {
        this.preference = preference;
    }

    @NonNull
    public static Set<DeploySourceOrigin> all() {
        return ResourceHolder.DEPLOYABLE_SOURCES;
    }

    @NonNull
    public static List<DeploySourceOrigin> allInPreferenceOrder() {
        return ResourceHolder.DEPLOYABLE_SOURCES_IN_PREFERENCE_ORDER;
    }

    private static final class ResourceHolder {
        @NonNull
        public static final Set<DeploySourceOrigin> DEPLOYABLE_SOURCES = Collections.unmodifiableSet(new LinkedHashSet<DeploySourceOrigin>(Arrays.asList(DeploySourceOrigin.values())));
        @NonNull
        public static final List<DeploySourceOrigin> DEPLOYABLE_SOURCES_IN_PREFERENCE_ORDER = ResourceHolder.createPreferenceOrder();

        private ResourceHolder() {
        }

        @NonNull
        private static List<DeploySourceOrigin> createPreferenceOrder() {
            ArrayList<DeploySourceOrigin> sources = new ArrayList<DeploySourceOrigin>(Arrays.asList(DeploySourceOrigin.values()));
            Collections.sort(sources, new Comparator<DeploySourceOrigin>(){

                @Override
                public int compare(DeploySourceOrigin o1, DeploySourceOrigin o2) {
                    return o2.preference - o1.preference;
                }
            });
            return Collections.unmodifiableList(sources);
        }
    }
}

