/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowCause;
import com.cloudbees.plugins.deployer.DeployNowColumn;
import com.cloudbees.plugins.deployer.DeployNowJobProperty;
import com.cloudbees.plugins.deployer.DeployNowTask;
import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.engines.Engine;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostsContext;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleLogFilter;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.RunAction;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TransientBuildActionFactory;
import hudson.model.listeners.RunListener;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.tasks.BuildWrapper;
import hudson.util.FlushProofOutputStream;
import hudson.util.HttpResponses;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class DeployNowRunAction
implements RunAction {
    private Run<?, ?> owner;
    private volatile transient Deployer deployer;
    public static final PermissionGroup DEPLOY_NOW = new PermissionGroup(DeployNowRunAction.class, Messages._DeployNowRunAction_PermissionGroup());
    public static final Permission CONFIGURE = AbstractProject.CONFIGURE;
    public static final Permission DEPLOY = new Permission(DEPLOY_NOW, "Deploy", null, CONFIGURE, PermissionScope.ITEM);
    public static final Permission OWN_AUTH = new Permission(DEPLOY_NOW, "UserCredentials", null, DEPLOY, PermissionScope.ITEM);
    public static final Permission JOB_AUTH = new Permission(DEPLOY_NOW, "JobCredentials", null, CONFIGURE, PermissionScope.ITEM);

    public DeployNowRunAction() {
        this(null);
    }

    public DeployNowRunAction(Run<?, ?> owner) {
        this.owner = owner;
    }

    public DeployHostsContext<DeployNowRunAction> createHostsContext() {
        DeployNowJobProperty property;
        List<DeployHost<?, ?>> hosts = null;
        if (this.owner != null && (property = (DeployNowJobProperty)this.owner.getParent().getProperty(DeployNowJobProperty.class)) != null) {
            hosts = property.getHosts();
            hosts = DeployHost.updateDefaults(this.owner, Collections.singleton(DeploySourceOrigin.RUN), hosts);
        }
        if (hosts == null) {
            hosts = DeployHost.createDefaults(this.owner, Collections.singleton(DeploySourceOrigin.RUN));
        }
        return new DeployHostsContext<DeployNowRunAction>(this, hosts == null ? Collections.emptyList() : hosts, this.owner == null ? null : this.owner.getParent(), Collections.singleton(DeploySourceOrigin.RUN), false, true);
    }

    @Exported(name="oneClickDeployPossible", visibility=2)
    public boolean isOneClickDeployPossible() {
        return DeployNowColumn.DescriptorImpl.isDeployPossible(this.owner);
    }

    @Exported(name="oneClickDeployReady", visibility=2)
    public boolean isOneClickDeploy() {
        DeployNowJobProperty property;
        if (this.owner != null && (property = (DeployNowJobProperty)this.owner.getParent().getProperty(DeployNowJobProperty.class)) != null) {
            return property.isOneClickDeploy();
        }
        return true;
    }

    @Exported(name="oneClickDeployValid", visibility=2)
    public boolean isOneClickDeployValid() {
        DeployNowJobProperty property;
        if (this.owner != null && this.owner.getParent().hasPermission(DEPLOY) && (property = (DeployNowJobProperty)this.owner.getParent().getProperty(DeployNowJobProperty.class)) != null && property.isOneClickDeploy()) {
            List<? extends DeployHost<?, ?>> sets = property.getHosts();
            if (this.owner.getParent().hasPermission(OWN_AUTH) && DeployHost.isValid(sets, this.owner, Hudson.getAuthentication())) {
                return true;
            }
            if (this.owner.getParent().hasPermission(JOB_AUTH) && DeployHost.isValid(sets, this.owner, ACL.SYSTEM)) {
                return true;
            }
        }
        return false;
    }

    public boolean isSaveConfigForced() {
        if (this.owner != null) {
            DeployNowJobProperty property = (DeployNowJobProperty)this.owner.getParent().getProperty(DeployNowJobProperty.class);
            return property == null;
        }
        return false;
    }

    public HttpResponse doIndex(StaplerRequest req) {
        if (!DeployNowColumn.DescriptorImpl.isDeployPossible(this.owner)) {
            return HttpResponses.notFound();
        }
        return HttpResponses.forwardToView((Object)this, (String)"configure");
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Value returned by delete() is not needed")
    public HttpResponse doDeploy(StaplerRequest req) throws ServletException {
        if ("POST".equalsIgnoreCase(req.getMethod()) && this.owner.getParent().hasPermission(DEPLOY) && DeployNowRunAction.hasSubmittedForm(req)) {
            JSONObject json = req.getSubmittedForm();
            List sets = req.bindJSONToList(DeployHost.class, json.get("hosts"));
            boolean saveConfig = json.optBoolean("saveConfig");
            boolean oneClickDeploy = json.optBoolean("oneClickDeploy");
            if (this.owner.getParent().hasPermission(CONFIGURE) && (oneClickDeploy || saveConfig)) {
                AbstractProject parent = (AbstractProject)this.owner.getParent();
                DeployNowJobProperty property = (DeployNowJobProperty)parent.getProperty(DeployNowJobProperty.class);
                try {
                    if (property == null) {
                        property = new DeployNowJobProperty(oneClickDeploy, sets);
                        parent.addProperty((JobProperty)property);
                    } else {
                        property.setOneClickDeploy(oneClickDeploy);
                        if (saveConfig) {
                            property.setHosts(sets);
                        }
                        parent.save();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!(this.owner.getParent().hasPermission(OWN_AUTH) && DeployHost.isValid(sets, this.owner, Hudson.getAuthentication()) || this.owner.getParent().hasPermission(JOB_AUTH) && DeployHost.isValid(sets, this.owner, ACL.SYSTEM))) {
                return HttpResponses.forwardToPreviousPage();
            }
            if (this.deployer == null) {
                this.getLogFile().delete();
                try {
                    this.getLogFile().createNewFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Hudson.getInstance().getQueue().schedule((Queue.Task)new DeployNowTask((AbstractBuild)this.owner, new Deployer(sets, Arrays.asList(new Cause[]{new Cause.UserCause(), new DeployNowCause()}), Jenkins.getAuthentication())), 0);
        }
        return HttpResponses.forwardToView((Object)this, (String)"_deploy");
    }

    private static boolean hasSubmittedForm(StaplerRequest req) {
        if (StringUtils.startsWith((String)req.getContentType(), (String)"multipart/")) {
            FileItem item = null;
            try {
                item = req.getFileItem("json");
            }
            catch (ServletException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            return item != null;
        }
        return req.getParameter("json") != null;
    }

    public String getIconFileName() {
        return this.owner != null && DeployNowColumn.DescriptorImpl.isDeployPossible(this.owner) ? Jenkins.RESOURCE_PATH + "/plugin/deployer-framework/images/24x24/deploy-now.png" : null;
    }

    public String getDisplayName() {
        return Messages.DeployNowRunAction_DisplayName();
    }

    public Set<DeploySourceOrigin> getSources() {
        return Collections.singleton(DeploySourceOrigin.RUN);
    }

    public String getUrlName() {
        return "deploy-now";
    }

    public void onLoad() {
    }

    public void onAttached(Run r) {
        this.owner = r;
    }

    public void onBuildComplete() {
    }

    public Run getOwner() {
        return this.owner;
    }

    public boolean isHasOutput() {
        return this.deployer != null || this.getLogFile().isFile();
    }

    public File getLogFile() {
        return new File(this.owner.getRootDir(), "cloudbees-deploy-now.log");
    }

    public boolean isLogUpdated() {
        if (this.deployer != null) {
            return true;
        }
        for (Queue.Item item : Hudson.getInstance().getQueue().getItems()) {
            if (!(item.task instanceof DeployNowTask) || !this.owner.equals(((DeployNowTask)((Object)DeployNowTask.class.cast(item.task))).getBuild())) continue;
            return true;
        }
        return false;
    }

    public final Charset getCharset() {
        return this.owner.getCharset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeployText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        FlushProofOutputStream out = new FlushProofOutputStream(rsp.getCompressedOutputStream((HttpServletRequest)req));
        try {
            this.getLogText().writeLogTo(0L, (OutputStream)out);
        }
        catch (IOException e) {
            InputStream input = this.getLogInputStream();
            try {
                IOUtils.copy((InputStream)input, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
        out.close();
    }

    public InputStream getLogInputStream() throws IOException {
        File logFile = this.getLogFile();
        if (logFile.exists()) {
            return new FileInputStream(logFile);
        }
        File compressedLogFile = new File(logFile.getParentFile(), logFile.getName() + ".gz");
        if (compressedLogFile.exists()) {
            return new GZIPInputStream(new FileInputStream(compressedLogFile));
        }
        return new NullInputStream(0L);
    }

    public Reader getLogReader() throws IOException {
        return new InputStreamReader(this.getLogInputStream(), this.getCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        try {
            this.getLogText().writeHtmlTo(offset, out.asWriter());
        }
        catch (IOException e) {
            InputStream input = this.getLogInputStream();
            try {
                IOUtils.copy((InputStream)input, (Writer)out.asWriter());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }

    public AnnotatedLargeText getLogText() {
        return new AnnotatedLargeText(this.getLogFile(), this.getCharset(), !this.isLogUpdated(), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLog(int maxLines) throws IOException {
        int lineCount = 0;
        LinkedList<String> logLines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getLogFile()), this.getCharset()));){
            String line = reader.readLine();
            while (line != null) {
                logLines.add(line);
                if (++lineCount > maxLines) {
                    logLines.remove(0);
                }
                line = reader.readLine();
            }
        }
        if (lineCount > maxLines) {
            logLines.set(0, "[...truncated " + (lineCount - (maxLines - 1)) + " lines...]");
        }
        return ConsoleNote.removeNotes(logLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Value returned by delete() is not needed")
    protected final void run(Deployer deployer) {
        if (this.deployer != null) {
            return;
        }
        this.getLogFile().delete();
        StreamBuildListener listener = null;
        this.deployer = deployer;
        Result result = Result.SUCCESS;
        try {
            long start = System.currentTimeMillis();
            OutputStream logger = null;
            try {
                try {
                    logger = new FileOutputStream(this.getLogFile());
                    for (Object filter : ConsoleLogFilter.all()) {
                        logger = filter.decorateLogger((AbstractBuild)this.owner, logger);
                    }
                    if (this.owner.getParent() instanceof BuildableItemWithBuildWrappers && this.owner instanceof AbstractBuild) {
                        BuildableItemWithBuildWrappers biwbw = (BuildableItemWithBuildWrappers)this.owner.getParent();
                        for (BuildWrapper bw : biwbw.getBuildWrappersList()) {
                            logger = bw.decorateLogger((AbstractBuild)this.owner, logger);
                        }
                    }
                    listener = new StreamBuildListener(logger, this.getCharset());
                    listener.started(deployer.getCauses());
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (InterruptedException e) {
                    listener.getLogger().println(Messages.DeployNowRunAction_BuildAborted());
                }
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    throw new IllegalStateException("Jenkins has shut down or not yet started.");
                }
                Launcher launcher = jenkins.createLauncher(listener);
                if (!deployer.perform((AbstractBuild<?, ?>)((AbstractBuild)this.owner), launcher, (BuildListener)listener)) {
                    result = Result.FAILURE;
                }
                this.owner.save();
            }
            catch (ThreadDeath t) {
                result = Result.FAILURE;
                throw t;
            }
            catch (IOException e) {
                result = Result.FAILURE;
            }
            catch (InterruptedException e) {
                result = Result.ABORTED;
                if (listener != null) {
                    listener.getLogger().println(Messages.DeployNowRunAction_BuildAborted());
                }
            }
            finally {
                long end = System.currentTimeMillis();
                long duration = Math.max(end - start, 0L);
                if (listener != null) {
                    listener.getLogger().println("Duration: " + Util.getTimeSpanString((long)duration));
                    listener.finished(result);
                    listener.closeQuietly();
                }
                IOUtils.closeQuietly((OutputStream)logger);
            }
        }
        finally {
            this.deployer = null;
        }
    }

    public static class Deployer {
        private final List<DeployHost<?, ?>> sets;
        private final List<Cause> causes;
        private final Authentication authentication;

        public Deployer(List<DeployHost<?, ?>> sets, List<Cause> causes, Authentication authentication) {
            this.sets = sets;
            this.causes = causes;
            this.authentication = authentication;
        }

        public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            ACL acl = build.getProject().getACL();
            ArrayList<Authentication> deployAuthentications = new ArrayList<Authentication>();
            if (acl.hasPermission(this.authentication, OWN_AUTH)) {
                deployAuthentications.add(this.authentication);
            }
            if (acl.hasPermission(this.authentication, JOB_AUTH)) {
                deployAuthentications.add(ACL.SYSTEM);
            }
            try {
                for (DeployHost<?, ?> set : this.sets) {
                    if (Engine.create(set).withCredentials((Item)build.getProject(), ACL.SYSTEM).from(build, DeploySourceOrigin.RUN).withLauncher(launcher).withListener(listener).build().perform()) continue;
                    return false;
                }
            }
            catch (Throwable t) {
                t.printStackTrace(listener.getLogger());
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Deployer deployer = (Deployer)o;
            return !(this.sets != null ? !this.sets.equals(deployer.sets) : deployer.sets != null);
        }

        public int hashCode() {
            return this.sets != null ? this.sets.hashCode() : 0;
        }

        public String toString() {
            return this.sets.toString();
        }

        public String getDisplayName() {
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            buf.append("[");
            for (DeployHost<?, ?> set : this.sets) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(set.getDisplayName());
            }
            buf.append("]");
            return buf.toString();
        }

        public List<Cause> getCauses() {
            return this.causes;
        }
    }

    @Extension
    public static class TransientBuildActionFactoryImpl
    extends TransientBuildActionFactory {
        public Collection<? extends Action> createFor(Run target) {
            Job job = target.getParent();
            if (job instanceof AbstractProject && CapabilitiesResolver.of((AbstractProject)job).isInstantApplicable() && target.getActions(DeployNowRunAction.class).isEmpty()) {
                return Collections.singleton(new DeployNowRunAction(target));
            }
            return Collections.emptySet();
        }
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run> {
        public void onStarted(Run run, TaskListener listener) {
            if (run.getActions(DeployNowRunAction.class).isEmpty()) {
                try {
                    run.addAction((Action)new DeployNowRunAction());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

