/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.DeployNowJobProperty;
import com.cloudbees.plugins.deployer.DeployNowRunAction;
import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenAggregatedArtifactRecord;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeployNowColumn
extends ListViewColumn {
    @DataBoundConstructor
    public DeployNowColumn() {
    }

    public boolean isDeployPossible(Item item) {
        return DescriptorImpl.isDeployPossible(item);
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        private final Map<Run, Boolean> deployPossibleCache = new WeakHashMap<Run, Boolean>();
        private final Map<Run, Map<DeploySource, Boolean>> sourceHasNoFile = new WeakHashMap<Run, Map<DeploySource, Boolean>>();

        public boolean shownByDefault() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Boolean cache(Run run, DeploySource source) {
            Map<Run, Map<DeploySource, Boolean>> map = this.sourceHasNoFile;
            synchronized (map) {
                Map<DeploySource, Boolean> map2 = this.sourceHasNoFile.get(run);
                return map2 != null ? map2.get(source) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cache(Run run, DeploySource source, boolean answer) {
            Map<Run, Map<DeploySource, Boolean>> map = this.sourceHasNoFile;
            synchronized (map) {
                Map<DeploySource, Boolean> map2 = this.sourceHasNoFile.get(run);
                if (map2 == null) {
                    map2 = new LinkedHashMap<DeploySource, Boolean>();
                    this.sourceHasNoFile.put(run, map2);
                }
                map2.put(source, answer);
                return answer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Boolean cache(Run run) {
            Map<Run, Boolean> map = this.deployPossibleCache;
            synchronized (map) {
                return this.deployPossibleCache.get(run);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cache(Run run, boolean answer) {
            Map<Run, Boolean> map = this.deployPossibleCache;
            synchronized (map) {
                this.deployPossibleCache.put(run, answer);
            }
            return answer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decache(Run run) {
            Map<Run, Boolean> map = this.deployPossibleCache;
            synchronized (map) {
                this.deployPossibleCache.remove(run);
            }
        }

        public String getDisplayName() {
            return Messages.DeployNowColumn_DisplayName();
        }

        public static boolean isDeployPossible(Item item) {
            Run<?, ?> lastDeployable;
            block11: {
                block10: {
                    if (!(item instanceof AbstractProject)) {
                        return false;
                    }
                    AbstractProject project = (AbstractProject)item;
                    if (!CapabilitiesResolver.of(project).isInstantApplicable()) {
                        return false;
                    }
                    if (!project.hasPermission(DeployNowRunAction.DEPLOY)) {
                        return false;
                    }
                    lastDeployable = CapabilitiesResolver.getLastDeployableBuild(project);
                    if (lastDeployable == null) {
                        return false;
                    }
                    DeployNowJobProperty deployNow = (DeployNowJobProperty)project.getProperty(DeployNowJobProperty.class);
                    if (deployNow != null && !deployNow.getHosts().isEmpty() && DescriptorImpl.hasArtifacts(lastDeployable)) {
                        boolean checkedOne = false;
                        DescriptorImpl instance = DescriptorImpl.instance();
                        for (DeployHost<?, ?> host : deployNow.getHosts()) {
                            for (DeployTarget target : host.getTargets()) {
                                DeploySource s = target.getArtifact();
                                if (s == null) continue;
                                checkedOne = true;
                                if (!Boolean.TRUE.equals(instance.cache(lastDeployable, s)) && !instance.cache(lastDeployable, s, s.getApplicationFile(lastDeployable) == null)) continue;
                                return false;
                            }
                        }
                        if (checkedOne) {
                            return true;
                        }
                    }
                    if (!(item instanceof MavenModuleSet)) break block10;
                    MavenModuleSet maven = (MavenModuleSet)item;
                    for (MavenModule m : maven.getModules()) {
                        if (!DescriptorImpl.isDeployPossible((Item)m)) continue;
                        return true;
                    }
                    break block11;
                }
                if (!(item instanceof MatrixProject)) break block11;
                MatrixProject matrix = (MatrixProject)item;
                for (MavenModule m : matrix.getActiveConfigurations()) {
                    if (!DescriptorImpl.isDeployPossible((Item)m)) continue;
                    return true;
                }
            }
            return DescriptorImpl.isDeployPossible(lastDeployable);
        }

        private static boolean hasArtifacts(Run run) {
            MavenArtifactRecord r;
            MavenAggregatedArtifactRecord mavenArtifacts;
            if (run instanceof MavenModuleSetBuild && (mavenArtifacts = ((MavenModuleSetBuild)run).getMavenArtifacts()) != null) {
                for (MavenArtifactRecord r2 : mavenArtifacts.getModuleRecords()) {
                    if (r2.mainArtifact != null && !"pom".equals(r2.mainArtifact.type)) {
                        return true;
                    }
                    if (r2.attachedArtifacts.isEmpty()) continue;
                    return true;
                }
            }
            if (run instanceof MavenBuild && (r = ((MavenBuild)run).getMavenArtifacts()) != null) {
                if (r.mainArtifact != null && !"pom".equals(r.mainArtifact.type)) {
                    return true;
                }
                if (!r.attachedArtifacts.isEmpty()) {
                    return true;
                }
            }
            return run.getHasArtifacts();
        }

        public static boolean isDeployPossible(Run run) {
            if (Hudson.getInstance().isQuietingDown() || Hudson.getInstance().isTerminating()) {
                return false;
            }
            if (run instanceof MavenModuleSetBuild) {
                Boolean cached = DescriptorImpl.getCachedDeployPossible(run);
                return cached != null ? cached : DescriptorImpl.setCachedDeployPossible(run, DescriptorImpl.foundWar(((MavenModuleSetBuild)run).getMavenArtifacts()));
            }
            if (run instanceof MavenBuild) {
                Boolean cached = DescriptorImpl.getCachedDeployPossible(run);
                return cached != null ? cached : DescriptorImpl.setCachedDeployPossible(run, DescriptorImpl.foundWar(((MavenBuild)run).getMavenArtifacts()));
            }
            if (run.getHasArtifacts()) {
                Boolean cached = DescriptorImpl.getCachedDeployPossible(run);
                return cached != null ? cached : DescriptorImpl.setCachedDeployPossible(run, DescriptorImpl.foundWar(run.getArtifactsDir()));
            }
            DescriptorImpl.removeCachedDeployPossible(run);
            return false;
        }

        private static Boolean getCachedDeployPossible(Run lastSuccessfulBuild) {
            return DescriptorImpl.instance().cache(lastSuccessfulBuild);
        }

        private static boolean setCachedDeployPossible(Run lastSuccessfulBuild, boolean deployPossible) {
            return DescriptorImpl.instance().cache(lastSuccessfulBuild, deployPossible);
        }

        private static void removeCachedDeployPossible(Run lastSuccessfulBuild) {
            DescriptorImpl.instance().decache(lastSuccessfulBuild);
        }

        @NonNull
        private static DescriptorImpl instance() {
            return (DescriptorImpl)Hudson.getInstance().getDescriptorOrDie(DeployNowColumn.class);
        }

        private static boolean foundWar(MavenAggregatedArtifactRecord mavenArtifacts) {
            if (mavenArtifacts != null) {
                for (MavenArtifactRecord r : mavenArtifacts.getModuleRecords()) {
                    if (!DescriptorImpl.foundWar(r)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean foundWar(MavenArtifactRecord mavenArtifacts) {
            if (mavenArtifacts != null) {
                if (mavenArtifacts.mainArtifact != null && "war".equals(mavenArtifacts.mainArtifact.type)) {
                    return true;
                }
                for (MavenArtifact a : mavenArtifacts.attachedArtifacts) {
                    if (!"war".equals(a.type)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean foundWar(File file) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (f == null || !f.isFile() || !f.getName().endsWith(".war")) continue;
                        return true;
                    }
                    for (File f : files) {
                        if (!f.isDirectory() || !DescriptorImpl.foundWar(f)) continue;
                        return true;
                    }
                }
            } else if (!file.isFile()) {
                return file.getName().endsWith(".war");
            }
            return false;
        }
    }
}

