/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.engines.Engine;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostDescriptor;
import com.cloudbees.plugins.deployer.hosts.DeployHostsContext;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeployBuilder
extends Builder {
    private final List<? extends DeployHost<?, ?>> hosts;

    @DataBoundConstructor
    public DeployBuilder(List<? extends DeployHost<?, ?>> hosts) {
        this.hosts = new ArrayList(hosts == null ? Collections.emptySet() : hosts);
    }

    public List<? extends DeployHost<?, ?>> getHosts() {
        return this.hosts;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            for (DeployHost<?, ?> set : this.hosts) {
                if (Engine.create(set).withCredentials((Item)build.getProject(), ACL.SYSTEM).from(build, DeploySourceOrigin.WORKSPACE).withLauncher(launcher).withListener(listener).build().perform()) continue;
                return false;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(listener.getLogger());
            return false;
        }
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            if (CapabilitiesResolver.of(jobType).isBuilderApplicable()) {
                boolean haveSource = false;
                for (Descriptor d : Hudson.getInstance().getDescriptorList(DeploySource.class)) {
                    DeploySourceDescriptor descriptor;
                    if (!(d instanceof DeploySourceDescriptor) || !(descriptor = (DeploySourceDescriptor)d).isApplicable(jobType) || !descriptor.isSupported(DeploySourceOrigin.WORKSPACE)) continue;
                    haveSource = true;
                    break;
                }
                if (haveSource) {
                    for (Descriptor d : DeployHostDescriptor.all()) {
                        if (!d.isSupported(Collections.singleton(DeploySourceOrigin.WORKSPACE), jobType)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public String getDisplayName() {
            return Messages.DeployBuilder_DisplayName();
        }

        public DeployHostsContext<AbstractProject<?, ?>> createHostsContext(AbstractProject<?, ?> it, DeployBuilder instance) {
            CapabilitiesResolver resolver = CapabilitiesResolver.of(it);
            return new DeployHostsContext(it, instance == null ? DeployHost.createDefaults(it, resolver.getBuilderSources(it)) : instance.getHosts(), (Job<?, ?>)it, resolver.getBuilderSources(it), resolver.isBuilderFromWorkspace(), false);
        }
    }
}

