/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.hosts;

import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractProject;
import hudson.model.Job;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public class DeployHostsContext<T> {
    @NonNull
    private final T it;
    @NonNull
    private final List<? extends DeployHost<?, ?>> hosts;
    @CheckForNull
    private final Job<?, ?> project;
    @NonNull
    private final Set<DeploySourceOrigin> origins;
    private final boolean fromWorkspace;
    private final boolean usersAuth;

    public DeployHostsContext(@NonNull T it, @NonNull List<? extends DeployHost<?, ?>> hosts, @CheckForNull Job<?, ?> project, @NonNull Set<DeploySourceOrigin> origins, boolean fromWorkspace, boolean usersAuth) {
        it.getClass();
        hosts.getClass();
        origins.getClass();
        this.it = it;
        this.hosts = hosts;
        this.project = project;
        this.origins = origins;
        this.fromWorkspace = fromWorkspace;
        this.usersAuth = usersAuth;
    }

    public boolean isUsersAuth() {
        return this.usersAuth;
    }

    @CheckForNull
    public Job<?, ?> getProject() {
        return this.project;
    }

    @NonNull
    public Set<DeploySourceOrigin> getOrigins() {
        return this.origins;
    }

    @NonNull
    public T getIt() {
        return this.it;
    }

    public boolean isFromWorkspace() {
        return this.fromWorkspace;
    }

    @NonNull
    public List<? extends DeployHost<?, ?>> getHosts() {
        return this.hosts;
    }

    public List<DeployHostDescriptor<?, ?>> getDescriptors() {
        return DeployHostDescriptor.allSupported(this.origins, this.project instanceof AbstractProject ? ((AbstractProject)this.project).getClass() : null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployHostsContext");
        sb.append("{it=").append(this.it);
        sb.append(", hosts=").append(this.hosts);
        sb.append(", project=").append(this.project);
        sb.append(", origins=").append(this.origins);
        sb.append(", fromWorkspace=").append(this.fromWorkspace);
        sb.append(", usersAuth=").append(this.usersAuth);
        sb.append('}');
        return sb.toString();
    }
}

