/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer;

import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.engines.Engine;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostDescriptor;
import com.cloudbees.plugins.deployer.hosts.DeployHostsContext;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceDescriptor;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeployPublisher
extends Notifier {
    private boolean deployIfUnstable;
    private final List<? extends DeployHost<?, ?>> hosts;

    @DataBoundConstructor
    public DeployPublisher(List<? extends DeployHost<?, ?>> hosts, boolean deployIfUnstable) {
        this.hosts = new ArrayList(hosts == null ? Collections.emptySet() : hosts);
        this.deployIfUnstable = deployIfUnstable;
    }

    public boolean isDeployIfUnstable() {
        return this.deployIfUnstable;
    }

    public List<? extends DeployHost<?, ?>> getHosts() {
        return this.hosts;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result result = build.getResult();
        if (result != null && result.isWorseThan(this.deployIfUnstable ? Result.UNSTABLE : Result.SUCCESS)) {
            listener.getLogger().println("[cloudbees-deployer] Skipping deployment as build result is " + result.toString());
            return true;
        }
        try {
            for (DeployHost<?, ?> set : this.hosts) {
                if (Engine.create(set).withCredentials((Item)build.getProject(), ACL.SYSTEM).from(build, DeploySourceOrigin.WORKSPACE, DeploySourceOrigin.RUN).withLauncher(launcher).withListener(listener).build().perform()) continue;
                return false;
            }
        }
        catch (Throwable t) {
            t.printStackTrace(listener.getLogger());
            return false;
        }
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            if (CapabilitiesResolver.of(jobType).isBuilderApplicable()) {
                HashSet<DeploySourceOrigin> have = new HashSet<DeploySourceOrigin>();
                HashSet<DeploySourceOrigin> want = new HashSet<DeploySourceOrigin>(Arrays.asList(DeploySourceOrigin.WORKSPACE, DeploySourceOrigin.RUN));
                for (Descriptor d : Hudson.getInstance().getDescriptorList(DeploySource.class)) {
                    DeploySourceDescriptor descriptor;
                    if (!(d instanceof DeploySourceDescriptor) || !(descriptor = (DeploySourceDescriptor)d).isApplicable(jobType)) continue;
                    Iterator iterator = want.iterator();
                    while (iterator.hasNext()) {
                        DeploySourceOrigin origin = (DeploySourceOrigin)((Object)iterator.next());
                        if (!descriptor.isSupported(origin)) continue;
                        have.add(origin);
                        iterator.remove();
                    }
                    if (!want.isEmpty()) continue;
                    break;
                }
                if (!have.isEmpty()) {
                    for (Descriptor d : DeployHostDescriptor.all()) {
                        if (!d.isSupported(have, jobType)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public String getDisplayName() {
            return Messages.DeployPublisher_DisplayName();
        }

        public DeployHostsContext<AbstractProject<?, ?>> createHostsContext(AbstractProject<?, ?> it, DeployPublisher instance) {
            CapabilitiesResolver resolver = CapabilitiesResolver.of(it);
            return new DeployHostsContext(it, instance == null ? DeployHost.createDefaults(it, resolver.getPublisherSources(it)) : instance.getHosts(), (Job<?, ?>)it, resolver.getPublisherSources(it), resolver.isPublisherFromWorkspace(), false);
        }
    }
}

