/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database;

import hudson.Util;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.jenkinsci.plugins.database.BasicDataSource2;
import org.jenkinsci.plugins.database.Database;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractRemoteDatabase
extends Database
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String hostname;
    public final String database;
    public final String username;
    public final Secret password;
    public String validationQuery;
    public final String properties;
    private transient DataSource source;

    public AbstractRemoteDatabase(String hostname, String database, String username, Secret password, String properties) {
        this.hostname = hostname;
        this.database = database;
        this.username = username;
        this.password = password;
        this.properties = properties;
    }

    @DataBoundSetter
    public void setValidationQuery(@QueryParameter String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    protected abstract Class<? extends Driver> getDriverClass();

    protected abstract String getJdbcUrl();

    @Override
    public synchronized DataSource getDataSource() throws SQLException {
        if (this.source == null) {
            BasicDataSource2 fac = new BasicDataSource2();
            fac.setDriverClass(this.getDriverClass());
            fac.setUrl(this.getJdbcUrl());
            fac.setUsername(this.username);
            fac.setPassword(Secret.toString((Secret)this.password));
            fac.setValidationQuery(this.validationQuery);
            try {
                for (Map.Entry<Object, Object> e : Util.loadProperties((String)Util.fixNull((String)this.properties)).entrySet()) {
                    fac.addConnectionProperty(e.getKey().toString(), e.getValue().toString());
                }
            }
            catch (IOException e) {
                throw new SQLException("Invalid properties", e);
            }
            this.source = fac.createDataSource();
        }
        return this.source;
    }
}

