/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers.health;

import hudson.model.HealthReport;
import hudson.model.Result;
import hudson.plugins.helpers.health.HealthMetric;
import java.io.Serializable;

public abstract class HealthTarget<M extends HealthMetric<OBSERVABLE>, OBSERVABLE>
implements Serializable {
    private final M metric;
    private final Float healthy;
    private final Float unhealthy;
    private final Float unstable;
    private final Float fail;
    private final Float failNew;

    public HealthTarget(M metric, String healthy, String unhealthy, String unstable, String fail, String failNew) {
        this.metric = metric;
        this.fail = HealthTarget.safeParse(fail);
        this.failNew = HealthTarget.safeParse(failNew);
        this.healthy = HealthTarget.safeParse(healthy);
        this.unhealthy = HealthTarget.safeParse(unhealthy);
        this.unstable = HealthTarget.safeParse(unstable);
    }

    private static Float safeParse(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public M getMetric() {
        return this.metric;
    }

    public Float getHealthy() {
        return this.healthy;
    }

    public Float getUnhealthy() {
        return this.unhealthy;
    }

    public Float getUnstable() {
        return this.unstable;
    }

    public Float getFail() {
        return this.fail;
    }

    public Float getFailNew() {
        return this.failNew;
    }

    public HealthReport evaluateHealth(OBSERVABLE observable, String descriptionPrefix) {
        float result = this.metric.measure(observable);
        float healthy = this.healthy == null ? this.metric.getBest() : this.healthy.floatValue();
        float unhealthy = this.unhealthy == null ? this.metric.getWorst() : this.unhealthy.floatValue();
        return new HealthReport(Math.max(0, Math.min(100, (int)((result - unhealthy) / (healthy - unhealthy) * 100.0f))), descriptionPrefix + this.metric.getName() + " (" + result + ")");
    }

    public Result evaluateStability(OBSERVABLE observable) {
        float unhealthy;
        float result = this.metric.measure(observable);
        float resultNew = this.metric.measureNew(observable);
        float healthy = this.healthy == null ? this.metric.getBest() : this.healthy.floatValue();
        float f = unhealthy = this.unhealthy == null ? this.metric.getWorst() : this.unhealthy.floatValue();
        if (this.fail != null && (healthy > unhealthy && result < this.fail.floatValue() || healthy < unhealthy && result > this.fail.floatValue())) {
            return Result.FAILURE;
        }
        if (this.failNew != null && (healthy > unhealthy && resultNew < this.failNew.floatValue() || healthy < unhealthy && resultNew > this.failNew.floatValue())) {
            return Result.FAILURE;
        }
        if (this.unstable != null && (healthy > unhealthy && result < this.unstable.floatValue() || healthy < unhealthy && result > this.unstable.floatValue())) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }
}

