/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.helpers.AbstractBuildAction;
import hudson.plugins.helpers.BuildProxyCallableHelper;
import hudson.plugins.helpers.Ghostwriter;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public final class BuildProxy
implements Serializable {
    private final FilePath artifactsDir;
    private final FilePath projectRootDir;
    private final FilePath buildRootDir;
    private final FilePath executionRootDir;
    private final Calendar timestamp;
    private final List<AbstractBuildAction<AbstractBuild<?, ?>>> actions = new ArrayList();
    private Result result = null;
    private boolean continueBuild = true;

    public static boolean doPerform(Ghostwriter ghostwriter, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        Ghostwriter.MasterGhostwriter masterGhostwriter;
        if (ghostwriter instanceof Ghostwriter.SlaveGhostwriter) {
            BuildProxy buildProxy = new BuildProxy(new FilePath(build.getArtifactsDir()), new FilePath(build.getProject().getRootDir()), new FilePath(build.getRootDir()), build.getModuleRoot(), build.getTimestamp());
            BuildProxyCallableHelper callableHelper = new BuildProxyCallableHelper(buildProxy, ghostwriter, listener);
            try {
                buildProxy = (BuildProxy)buildProxy.getExecutionRootDir().act((Callable)callableHelper);
                buildProxy.updateBuild(build);
                if (!buildProxy.isContinueBuild()) {
                    return false;
                }
            }
            catch (Exception e) {
                throw BuildProxy.unwrapException(e, listener);
            }
        }
        return (masterGhostwriter = (Ghostwriter.MasterGhostwriter)Ghostwriter.MasterGhostwriter.class.cast(ghostwriter)) == null || masterGhostwriter.performFromMaster(build, build.getModuleRoot(), listener);
    }

    private static RuntimeException unwrapException(Exception e, BuildListener listener) throws IOException, InterruptedException {
        if (e.getCause() instanceof IOException) {
            throw new IOException(e.getCause().getMessage(), e);
        }
        if (e.getCause() instanceof InterruptedException) {
            e.getCause().printStackTrace(listener.getLogger());
            throw new InterruptedException(e.getCause().getMessage());
        }
        if (e.getCause() instanceof RuntimeException) {
            RuntimeException ex = new RuntimeException(e.getCause());
            ex.addSuppressed(e);
            throw ex;
        }
        e.printStackTrace(listener.getLogger());
        throw new RuntimeException("Unexpected exception", e);
    }

    public void updateBuild(AbstractBuild<?, ?> build) {
        for (AbstractBuildAction<AbstractBuild<?, ?>> action : this.actions) {
            if (build.getActions().contains(action)) continue;
            action.setBuild(build);
            build.getActions().add(action);
        }
        Result currentResult = build.getResult();
        if (this.result != null && currentResult != null && this.result.isWorseThan(currentResult)) {
            build.setResult(this.result);
        }
    }

    private BuildProxy(FilePath artifactsDir, FilePath projectRootDir, FilePath buildRootDir, FilePath executionRootDir, Calendar timestamp) {
        this.artifactsDir = artifactsDir;
        this.projectRootDir = projectRootDir;
        this.buildRootDir = buildRootDir;
        this.executionRootDir = executionRootDir;
        this.timestamp = timestamp;
    }

    public List<AbstractBuildAction<AbstractBuild<?, ?>>> getActions() {
        return this.actions;
    }

    public FilePath getArtifactsDir() {
        return this.artifactsDir;
    }

    public FilePath getBuildRootDir() {
        return this.buildRootDir;
    }

    public FilePath getExecutionRootDir() {
        return this.executionRootDir;
    }

    public FilePath getProjectRootDir() {
        return this.projectRootDir;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public boolean isContinueBuild() {
        return this.continueBuild;
    }

    public void setContinueBuild(boolean continueBuild) {
        this.continueBuild = continueBuild;
    }
}

