/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.plugins.cppncss.parser.FormattedStatisticSummary;
import hudson.plugins.cppncss.parser.StatisticSummary;
import hudson.plugins.cppncss.parser.StatisticsResult;
import hudson.util.IOException2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Ignored in XStream")
public class Statistic
implements Serializable {
    @CheckForNull
    private transient AbstractBuild<?, ?> owner;
    private String name;
    private long functions;
    private long ncss;
    private long ccn;
    private String parentElement;

    public static StatisticsResult parse(File inFile) throws IOException, XmlPullParserException {
        StatisticsResult result = new StatisticsResult();
        ArrayList<Statistic> fileResults = new ArrayList<Statistic>();
        ArrayList<Statistic> functionResults = new ArrayList<Statistic>();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            Statistic s;
            String lastText;
            String lastTag;
            int subIndex;
            HashMap<String, String> data;
            fis = new FileInputStream(inFile);
            bis = new BufferedInputStream(fis);
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((InputStream)bis, null);
            Statistic.expectNextTag(parser, "cppncss");
            while (!(parser.getDepth() <= 0 || parser.getEventType() == 2 && "measure".equals(parser.getName()))) {
                parser.next();
            }
            int depth = parser.getDepth();
            while (!(parser.getDepth() <= 1 || parser.getEventType() == 2 && "item".equals(parser.getName()))) {
                parser.next();
            }
            while (parser.getDepth() >= depth) {
                if (parser.getDepth() == 3 && parser.getEventType() == 2 && "item".equals(parser.getName())) {
                    String functionName = parser.getAttributeValue(0);
                    data = new HashMap<String, String>();
                    data.put("name", functionName);
                    String[] functionValueNames = new String[]{"Nr.", "NCSS", "CCN"};
                    subIndex = 0;
                    lastTag = null;
                    lastText = null;
                    block18: while (parser.getDepth() >= 3) {
                        parser.next();
                        switch (parser.getEventType()) {
                            case 2: {
                                lastTag = parser.getName();
                                continue block18;
                            }
                            case 4: {
                                lastText = parser.getText();
                                continue block18;
                            }
                            case 3: {
                                ++subIndex;
                                if (parser.getDepth() == 4 && lastTag != null && lastText != null) {
                                    data.put(functionValueNames[subIndex - 1], lastText);
                                }
                                lastTag = null;
                                lastText = null;
                                continue block18;
                            }
                        }
                    }
                    s = new Statistic((String)data.get("name"));
                    if (((String)data.get("name")).indexOf(" at ") > 0) {
                        String fileStr = ((String)data.get("name")).substring(((String)data.get("name")).indexOf(" at ") + 4);
                        String file = fileStr.substring(0, fileStr.lastIndexOf(":"));
                        s.setParentElement(file);
                    }
                    s.setNcss(Long.parseLong(((String)data.get(functionValueNames[1])).trim()));
                    s.setCcn(Long.parseLong(((String)data.get(functionValueNames[2])).trim()));
                    functionResults.add(s);
                }
                parser.next();
            }
            while (!(parser.getDepth() <= 0 || parser.getEventType() == 2 && "measure".equals(parser.getName()))) {
                parser.next();
            }
            while (!(parser.getDepth() <= 1 || parser.getEventType() == 2 && "item".equals(parser.getName()))) {
                parser.next();
            }
            depth = parser.getDepth();
            while (parser.getDepth() >= depth) {
                if (parser.getDepth() == 3 && parser.getEventType() == 2 && "item".equals(parser.getName())) {
                    String fileName = parser.getAttributeValue(0);
                    data = new HashMap();
                    data.put("name", fileName);
                    String[] fileValueNames = new String[]{"Nr.", "NCSS", "CCN", "Functions"};
                    subIndex = 0;
                    lastTag = null;
                    lastText = null;
                    block22: while (parser.getDepth() >= 3) {
                        parser.next();
                        switch (parser.getEventType()) {
                            case 2: {
                                lastTag = parser.getName();
                                continue block22;
                            }
                            case 4: {
                                lastText = parser.getText();
                                continue block22;
                            }
                            case 3: {
                                ++subIndex;
                                if (parser.getDepth() == 4 && lastTag != null && lastText != null) {
                                    data.put(fileValueNames[subIndex - 1], lastText);
                                }
                                lastTag = null;
                                lastText = null;
                                continue block22;
                            }
                        }
                    }
                    s = new Statistic((String)data.get("name"));
                    s.setNcss(Long.parseLong(((String)data.get(fileValueNames[1])).trim()));
                    s.setCcn(Long.parseLong(((String)data.get(fileValueNames[2])).trim()));
                    s.setFunctions(Long.parseLong(((String)data.get(fileValueNames[3])).trim()));
                    fileResults.add(s);
                }
                parser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException2((Throwable)e);
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        result.setFunctionResults(functionResults);
        result.setFileResults(fileResults);
        return result;
    }

    private static boolean skipToTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException {
        while (parser.getEventType() != 3) {
            if (parser.getEventType() != 2) {
                parser.next();
                continue;
            }
            if (parser.getName().equals(tagName)) {
                return true;
            }
            Statistic.skipTag(parser);
        }
        return false;
    }

    private static void skipTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.next();
        Statistic.endElement(parser);
    }

    private static void expectNextTag(XmlPullParser parser, String tag) throws IOException, XmlPullParserException {
        while (parser.getEventType() != 2) {
            parser.next();
        }
        if (parser.getName().equals(tag)) {
            return;
        }
        throw new IOException("Expecting tag " + tag);
    }

    private static void endElement(XmlPullParser parser) throws IOException, XmlPullParserException {
        int depth = parser.getDepth();
        while (parser.getDepth() >= depth) {
            parser.next();
        }
    }

    public static Statistic total(Collection<Statistic> ... results) {
        Collection<Statistic> merged = Statistic.merge(results);
        Statistic total = new Statistic("");
        for (Statistic individual : merged) {
            total.add(individual);
        }
        return total;
    }

    public void add(Statistic r) {
        this.functions += r.functions;
        this.ncss += r.ncss;
        this.ccn += r.ccn;
    }

    public static Collection<Statistic> merge(Collection<Statistic> ... results) {
        ArrayList<Statistic> newResults = new ArrayList<Statistic>();
        if (results.length == 0) {
            return Collections.emptySet();
        }
        if (results.length == 1) {
            return results[0];
        }
        ArrayList<String> indivNames = new ArrayList<String>();
        for (Collection<Statistic> result : results) {
            for (Statistic individual : result) {
                if (indivNames.contains(individual.name)) continue;
                indivNames.add(individual.name);
            }
        }
        for (String indivName : indivNames) {
            Statistic indivStat = new Statistic(indivName);
            for (Collection<Statistic> result : results) {
                for (Statistic individual : result) {
                    if (!indivName.equals(individual.name)) continue;
                    indivStat.add(individual);
                }
            }
            newResults.add(indivStat);
        }
        return newResults;
    }

    public Statistic(String name) {
        this.name = name;
    }

    public void setCcn(long ccn) {
        this.ccn = ccn;
    }

    public long getCcn() {
        return this.ccn;
    }

    public long getFunctions() {
        return this.functions;
    }

    public void setFunctions(long functions) {
        this.functions = functions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getNcss() {
        return this.ncss;
    }

    public void setNcss(long ncss) {
        this.ncss = ncss;
    }

    @Deprecated
    @CheckForNull
    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
    }

    public void setParentElement(String parentElement) {
        this.parentElement = parentElement;
    }

    public String getParentElement() {
        return this.parentElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statistic statistic = (Statistic)o;
        if (this.ccn != statistic.ccn) {
            return false;
        }
        if (this.functions != statistic.functions) {
            return false;
        }
        if (this.ncss != statistic.ncss) {
            return false;
        }
        if (!this.name.equals(statistic.name)) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(statistic.owner) : statistic.owner != null);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "Statistic{name='" + this.name + '\'' + ", ccn=" + this.ccn + ", functions=" + this.functions + ", ncss=" + this.ncss + '}';
    }

    @Deprecated
    public String toSummary() {
        return this.getStatisticSummary().getHtmlSummary();
    }

    public StatisticSummary getStatisticSummary() {
        return new FormattedStatisticSummary(this.ccn, this.functions, this.ncss);
    }

    @Deprecated
    public String toSummary(Statistic totals) {
        return this.getStatisticSummary(totals).getHtmlSummary();
    }

    public StatisticSummary getStatisticSummary(Statistic totals) {
        return new FormattedStatisticSummary(totals, this);
    }

    public void set(Statistic that) {
        this.name = that.name;
        this.ccn = that.ccn;
        this.functions = that.functions;
        this.ncss = that.ncss;
    }
}

