/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cppncss;

import hudson.model.AbstractBuild;
import hudson.model.HealthReportingAction;
import hudson.plugins.cppncss.parser.StatisticSummary;
import hudson.plugins.cppncss.parser.StatisticsResult;
import hudson.plugins.cppncss.parser.StatisticsTotalResult;
import hudson.plugins.helpers.AbstractBuildAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractBuildReport<T extends AbstractBuild<?, ?>>
extends AbstractBuildAction<T>
implements HealthReportingAction {
    private final StatisticsResult results;
    private final StatisticsTotalResult totals;
    private final Integer functionCcnViolationThreshold;
    private final Integer functionNcssViolationThreshold;

    public AbstractBuildReport(StatisticsResult results, Integer functionCcnViolationThreshold, Integer functionNcssViolationThreshold) {
        this.results = results;
        this.functionCcnViolationThreshold = functionCcnViolationThreshold;
        this.functionNcssViolationThreshold = functionNcssViolationThreshold;
        this.totals = StatisticsResult.total(results);
    }

    public StatisticsResult getResults() {
        return this.results;
    }

    public StatisticsTotalResult getTotals() {
        return this.totals;
    }

    public Integer getFunctionCcnViolationThreshold() {
        return this.functionCcnViolationThreshold;
    }

    public Integer getFunctionNcssViolationThreshold() {
        return this.functionNcssViolationThreshold;
    }

    @Override
    public StatisticSummary getStatisticSummary() {
        AbstractBuild prevBuild;
        for (prevBuild = this.getBuild().getPreviousBuild(); prevBuild != null && prevBuild.getAction(this.getClass()) == null; prevBuild = prevBuild.getPreviousBuild()) {
        }
        if (prevBuild == null) {
            return this.totals.getStatisticSummary();
        }
        AbstractBuildReport action = (AbstractBuildReport)prevBuild.getAction(this.getClass());
        return this.totals.getStatisticSummary(action.getTotals());
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Cpp NCSS Report";
    }

    @Override
    public String getGraphName() {
        return "Cpp NCSS Trend";
    }

    public String getUrlName() {
        return "cppncss";
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        Calendar t = this.getBuild().getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.buildChart(this.getBuild(), this.functionCcnViolationThreshold, this.functionNcssViolationThreshold), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    @Override
    public boolean isGraphActive() {
        Object build = this.getBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getClass()) != null) {
                ++numPoints;
            }
            build = build.getPreviousBuild();
        }
        return true;
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

