/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.covcomplplot;

import hudson.model.AbstractBuild;
import hudson.plugins.covcomplplot.Pagination;
import hudson.plugins.covcomplplot.analyzer.Analyzer;
import hudson.plugins.covcomplplot.model.MethodInfo;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CovComplPlotMethods
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<MethodInfo> methodInfoList;
    private transient AbstractBuild<?, ?> owner;
    public final int cov;
    public final int compl;
    private final Analyzer analyzer;
    private final int page;
    private final int totalCount;

    public AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public CovComplPlotMethods(AbstractBuild<?, ?> owner, List<MethodInfo> methodInfoList, Analyzer analyzer, int cov, int compl, int page, int totalCount) {
        this.owner = owner;
        this.methodInfoList = methodInfoList;
        this.analyzer = analyzer;
        this.cov = cov;
        this.compl = compl;
        this.page = page;
        this.totalCount = totalCount;
    }

    public String getTitle() {
        int covLowerBound = this.cov * 10;
        int covUpperBound = (this.cov + 1) * 10 - 1;
        if (covUpperBound == 99) {
            covUpperBound = 100;
        }
        int complLowerBound = this.compl * 5;
        int complUpperBound = (this.compl + 1) * 5 - 1;
        if (complUpperBound == 34) {
            return String.format("%d method(s) in the range of coverage (%d%%~%d%%) and complexity (%d~)", this.totalCount, covLowerBound, covUpperBound, complLowerBound);
        }
        return String.format("%d method(s) in the range of coverage (%d%%~%d%%) and complexity (%d~%d)", this.totalCount, covLowerBound, covUpperBound, complLowerBound, complUpperBound);
    }

    public String getMethodUrl(MethodInfo methodInfo) {
        return this.analyzer.getHandler().getMethodUrlLocation(this.owner, methodInfo);
    }

    public Pagination getPagination() {
        return new Pagination(this.page, this.getTotalCount(), 20, String.format("?cov=%d&compl=%d&page=", this.cov, this.compl));
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
    }

    public List<MethodInfo> getMethodInfoList() {
        return this.methodInfoList;
    }

    public int getTotalCount() {
        return this.totalCount;
    }
}

