/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.integrations.rolebasedauth;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.integrations.rolebasedauth.RoleDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true)
@Restricted(value={NoExternalUse.class})
public class RoleBasedAuthorizationStrategyConfigurator
extends Configurator<RoleBasedAuthorizationStrategy>
implements RootElementConfigurator<RoleBasedAuthorizationStrategy> {
    @Override
    public String getName() {
        return "roleStrategy";
    }

    @Override
    public Class<RoleBasedAuthorizationStrategy> getTarget() {
        return RoleBasedAuthorizationStrategy.class;
    }

    @Override
    public RoleBasedAuthorizationStrategy configure(Object config) throws ConfiguratorException {
        Configurator roleDefinitionConfigurator = Configurator.lookupOrFail(RoleDefinition.class);
        Map map = (Map)config;
        HashMap<String, RoleMap> grantedRoles = new HashMap<String, RoleMap>();
        Object rolesConfig = map.get("roles");
        if (rolesConfig != null) {
            grantedRoles.put("globalRoles", RoleBasedAuthorizationStrategyConfigurator.retrieveRoleMap(rolesConfig, "global", roleDefinitionConfigurator));
            grantedRoles.put("projectRoles", RoleBasedAuthorizationStrategyConfigurator.retrieveRoleMap(rolesConfig, "items", roleDefinitionConfigurator));
            grantedRoles.put("slaveRoles", RoleBasedAuthorizationStrategyConfigurator.retrieveRoleMap(rolesConfig, "agents", roleDefinitionConfigurator));
        }
        return new RoleBasedAuthorizationStrategy(grantedRoles);
    }

    @Nonnull
    private static RoleMap retrieveRoleMap(@Nonnull Object config, @Nonnull String name, Configurator<RoleDefinition> configurator) throws ConfiguratorException {
        Map map = (Map)config;
        Collection c = (Collection)map.get(name);
        TreeMap<Role, Set<String>> resMap = new TreeMap<Role, Set<String>>();
        if (c == null) {
            return new RoleMap(resMap);
        }
        for (Object entry : c) {
            RoleDefinition definition = (RoleDefinition)configurator.configureNonNull(entry);
            resMap.put(definition.getRole(), definition.getAssignments());
        }
        return new RoleMap(resMap);
    }

    @Override
    @SuppressFBWarnings(value={"DM_NEW_FOR_GETCLASS"}, justification="We need a fully qualified type to do proper attribute binding")
    public Set<Attribute> describe() {
        Class<?> groupType = new HashSet().getClass();
        return new HashSet<Attribute>(Arrays.asList(new Attribute("global", groupType), new Attribute("items", groupType), new Attribute("agents", groupType)));
    }
}

