/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc.integrations.projectmatriaxauth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.security.Permission;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.jenkinsci.plugins.casc.integrations.globalmatrixauth.GroupPermissionDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true)
@Restricted(value={NoExternalUse.class})
public class ProjectMatrixAuthorizationStrategyConfigurator
extends Configurator<ProjectMatrixAuthorizationStrategy>
implements RootElementConfigurator<ProjectMatrixAuthorizationStrategy> {
    @Override
    public String getName() {
        return "projectMatrix";
    }

    @Override
    public Class<ProjectMatrixAuthorizationStrategy> getTarget() {
        return ProjectMatrixAuthorizationStrategy.class;
    }

    @Override
    public ProjectMatrixAuthorizationStrategy configure(Object config) throws ConfiguratorException {
        Map map = (Map)config;
        Collection o = (Collection)map.get("grantedPermissions");
        Configurator permissionConfigurator = Configurator.lookupOrFail(GroupPermissionDefinition.class);
        HashMap<Permission, Set<String>> grantedPermissions = new HashMap<Permission, Set<String>>();
        for (Object entry : o) {
            GroupPermissionDefinition gpd = (GroupPermissionDefinition)permissionConfigurator.configureNonNull(entry);
            gpd.grantPermission(grantedPermissions);
        }
        ProjectMatrixAuthorizationStrategy gms = new ProjectMatrixAuthorizationStrategy();
        for (Map.Entry permission : grantedPermissions.entrySet()) {
            for (String sid : (Set)permission.getValue()) {
                gms.add((Permission)permission.getKey(), sid);
            }
        }
        return gms;
    }

    @Override
    @SuppressFBWarnings(value={"DM_NEW_FOR_GETCLASS"}, justification="We need a fully qualified type to do proper attribute binding")
    public Set<Attribute> describe() {
        return Collections.singleton(new Attribute("grantedPermissions", new HashSet().getClass()));
    }
}

