/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.DescriptorExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescribableAttribute;

public class HeteroDescribableConfigurator
extends Configurator<Describable> {
    private final Class target;

    public HeteroDescribableConfigurator(Class clazz) {
        this.target = clazz;
    }

    @Override
    public Class<Describable> getTarget() {
        return this.target;
    }

    @Override
    public List<Configurator> getConfigurators() {
        DescriptorExtensionList candidates = Jenkins.getInstance().getDescriptorList(this.target);
        return candidates.stream().map(d -> Configurator.lookup(d.getKlass().toJavaClass())).filter(c -> c != null).collect(Collectors.toList());
    }

    @Override
    public Describable configure(Object config) throws ConfiguratorException {
        String shortname;
        Object subconfig = null;
        if (config instanceof String) {
            shortname = (String)config;
        } else if (config instanceof Map) {
            Map map = (Map)config;
            if (map.size() != 1) {
                throw new IllegalArgumentException("single entry map expected to configure a " + this.target.getName());
            }
            Map.Entry next = map.entrySet().iterator().next();
            shortname = (String)next.getKey();
            subconfig = next.getValue();
        } else {
            throw new IllegalArgumentException("Unexpected configuration type " + config);
        }
        DescriptorExtensionList candidates = Jenkins.getInstance().getDescriptorList(this.target);
        Class k = this.findDescribableBySymbol(shortname, (List<Descriptor>)candidates);
        Configurator configurator = Configurator.lookup(k);
        if (configurator == null) {
            throw new IllegalStateException("No configurator implementation to manage " + k);
        }
        return (Describable)configurator.configure(subconfig);
    }

    private Class findDescribableBySymbol(String shortname, List<Descriptor> candidates) {
        Class clazz;
        for (Descriptor d : candidates) {
            String symbol = DescribableAttribute.getSymbolName(d, this.getExtensionPoint(), this.target);
            if (!symbol.equalsIgnoreCase(shortname)) continue;
            return d.getKlass().toJavaClass();
        }
        Configurator c = Configurator.lookupForBaseType(this.target, shortname);
        if (c != null && Describable.class.isAssignableFrom(clazz = c.getTarget())) {
            return clazz;
        }
        throw new IllegalArgumentException("No " + this.target.getName() + " implementation found for " + shortname);
    }

    @Override
    public Set<Attribute> describe() {
        return Collections.EMPTY_SET;
    }
}

