/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.ExtensionList;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;

public class ExtensionConfigurator
extends BaseConfigurator {
    private final Class target;

    public ExtensionConfigurator(Class clazz) {
        this.target = clazz;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    public Object configure(Object c) throws ConfiguratorException {
        ExtensionList list = Jenkins.getInstance().getExtensionList(this.target);
        if (list.size() != 1) {
            throw new IllegalStateException();
        }
        Object o = list.get(0);
        if (c instanceof Map) {
            Map config = (Map)c;
            Set<Attribute> attributes = this.describe();
            for (Attribute attribute : attributes) {
                String name = attribute.getName();
                if (!config.containsKey(name)) continue;
                Class k = attribute.getType();
                Configurator configurator = Configurator.lookup(k);
                if (configurator == null) {
                    throw new IllegalStateException("No configurator implementation to manage " + k);
                }
                Object value = configurator.configure(config.get(name));
                try {
                    attribute.setValue(o, value);
                }
                catch (Exception e) {
                    throw new ConfiguratorException(this, "Failed to set attribute " + attribute, e);
                }
            }
        }
        return o;
    }
}

