/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import com.google.common.base.Defaults;
import hudson.model.Descriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.BaseConfigurator;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.DescribableAttribute;
import org.kohsuke.stapler.ClassDescriptor;

public class DataBoundConfigurator
extends BaseConfigurator<Object> {
    private static final Logger logger = Logger.getLogger(DataBoundConfigurator.class.getName());
    private final Class target;

    public DataBoundConfigurator(Class clazz) {
        this.target = clazz;
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    public Object configure(Object c) throws ConfiguratorException {
        Object object;
        Map config = c instanceof Map ? (Map)c : Collections.EMPTY_MAP;
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor == null) {
            throw new IllegalStateException(this.target.getName() + " is missing a @DataBoundConstructor");
        }
        Parameter[] parameters = constructor.getParameters();
        String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
        Object[] args = new Object[names.length];
        if (parameters.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                Object value = config.remove(names[i]);
                if (value == null && parameters[i].getAnnotation(Nonnull.class) != null) {
                    throw new IllegalArgumentException(names[i] + " is required to configure " + this.target);
                }
                Class<?> t = parameters[i].getType();
                if (value != null) {
                    if (Collection.class.isAssignableFrom(t)) {
                        if (!(value instanceof List)) {
                            throw new IllegalArgumentException(names[i] + " should be a list");
                        }
                        Type type = parameters[i].getParameterizedType();
                        Configurator lookup = Configurator.lookup(type);
                        ArrayList list = new ArrayList();
                        for (Object o : (List)value) {
                            list.add(lookup.configure(o));
                        }
                        args[i] = list;
                    } else {
                        Class<?> clazz = parameters[i].getParameterizedType();
                        Class<?> k = clazz != null ? clazz : t;
                        Configurator configurator = Configurator.lookup(k);
                        if (configurator == null) {
                            throw new IllegalStateException("No configurator implementation to manage " + k);
                        }
                        args[i] = configurator.configure(value);
                    }
                    logger.info("Setting " + this.target + "." + names[i] + " = " + value);
                    continue;
                }
                if (!t.isPrimitive()) continue;
                args[i] = Defaults.defaultValue(t);
            }
        }
        try {
            object = constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            ArrayList<String> argumentTypes = new ArrayList<String>(args.length);
            for (Object arg : args) {
                argumentTypes.add(arg != null ? arg.getClass().getName() : "null");
            }
            throw new ConfiguratorException(this, "Failed to construct instance of " + this.target + ". Constructor: " + constructor.toString() + ". Arguments: " + argumentTypes, ex);
        }
        Set<Attribute> attributes = this.describe();
        for (Attribute attribute : attributes) {
            Object value;
            String name = attribute.getName();
            Configurator lookup = Configurator.lookup(attribute.getType());
            if (!config.containsKey(name)) continue;
            Object yaml = config.get(name);
            if (attribute.isMultiple()) {
                ArrayList l = new ArrayList();
                for (Object o : (List)yaml) {
                    l.add(lookup.configure(o));
                }
                value = l;
            } else {
                value = lookup.configure(config.get(name));
            }
            try {
                attribute.setValue(object, value);
            }
            catch (Exception e) {
                throw new ConfiguratorException(this, "Failed to set attribute " + attribute, e);
            }
        }
        for (Method method : this.target.getMethods()) {
            if (method.getParameterCount() != 0 || method.getAnnotation(PostConstruct.class) == null) continue;
            try {
                method.invoke(object, null);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfiguratorException(this, "Failed to invoke configurator method " + method, e);
            }
        }
        return object;
    }

    @Override
    public String getName() {
        Descriptor d = this.getDescriptor();
        return DescribableAttribute.getSymbolName(d, this.getExtensionPoint(), this.getTarget());
    }

    private Descriptor getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getTarget());
    }

    @Override
    public Class getExtensionPoint() {
        Type superclass;
        Descriptor descriptor = this.getDescriptor();
        if (descriptor != null && (superclass = descriptor.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)superclass;
            Type type = genericSuperclass.getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        return super.getExtensionPoint();
    }

    @Override
    public Set<Attribute> describe() {
        Set<Attribute> attributes = super.describe();
        Constructor constructor = DataBoundConfigurator.getDataBoundConstructor(this.target);
        if (constructor != null) {
            Parameter[] parameters = constructor.getParameters();
            String[] names = ClassDescriptor.loadParameterNames((Constructor)constructor);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                Attribute a = this.detectActualType(names[i], p.getParameterizedType());
                if (a == null) continue;
                attributes.add(a);
            }
        }
        return attributes;
    }

    @Override
    public String getDisplayName() {
        Descriptor descriptor = this.getDescriptor();
        return descriptor != null ? descriptor.getDisplayName() : "";
    }
}

