/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.casc;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.ManagementLink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.casc.Attribute;
import org.jenkinsci.plugins.casc.Configurator;
import org.jenkinsci.plugins.casc.ConfiguratorException;
import org.jenkinsci.plugins.casc.RootElementConfigurator;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.yaml.snakeyaml.Yaml;

@Extension
public class ConfigurationAsCode
extends ManagementLink {
    public static final String CASC_JENKINS_CONFIG_PROPERTY = "casc.jenkins.config";
    public static final String CASC_JENKINS_CONFIG_ENV = "CASC_JENKINS_CONFIG";
    public static final String DEFAULT_JENKINS_YAML_PATH = "./jenkins.yaml";
    public static final String YAML_FILES_PATTERN = "glob:**.{yml,yaml,YAML,YML}";
    private long lastTimeLoaded;
    private List<String> sources = Collections.emptyList();

    @CheckForNull
    public String getIconFileName() {
        return "/plugin/configuration-as-code/img/logo-head.svg";
    }

    @CheckForNull
    public String getDisplayName() {
        return "Configuration as Code";
    }

    @CheckForNull
    public String getUrlName() {
        return "configuration-as-code";
    }

    public String getDescription() {
        return "An opinionated way to configure jenkins based on human-readable declarative configuration files";
    }

    public Date getLastTimeLoaded() {
        return new Date(this.lastTimeLoaded);
    }

    public List<String> getSources() {
        return this.sources;
    }

    @RequirePOST
    public void doReload(StaplerRequest request, StaplerResponse response) throws Exception {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return;
        }
        this.configure();
        response.sendRedirect("");
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void init() throws Exception {
        ConfigurationAsCode.get().configure();
    }

    public void configure() throws ConfiguratorException {
        String configParameter = System.getProperty(CASC_JENKINS_CONFIG_PROPERTY, System.getenv(CASC_JENKINS_CONFIG_ENV));
        if (ConfigurationAsCode.isSupportedURI(configParameter)) {
            this._configureWithURI(configParameter);
        } else {
            this._configureWithPaths(configParameter);
        }
        this.lastTimeLoaded = System.currentTimeMillis();
    }

    public static boolean isSupportedURI(String configurationParameter) {
        if (configurationParameter == null) {
            return false;
        }
        List<String> supportedProtocols = Arrays.asList("https", "http", "file");
        URI uri = URI.create(configurationParameter);
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        return supportedProtocols.contains(uri.getScheme());
    }

    private void _configureWithURI(String configParameter) throws ConfiguratorException {
        try {
            URL url = URI.create(configParameter).toURL();
            try (InputStreamReader reader = new InputStreamReader(url.openStream(), "UTF-8");){
                for (Map.Entry entry : ConfigurationAsCode.entries(reader).collect(Collectors.toList())) {
                    ConfigurationAsCode.configureWith(entry);
                }
                this.sources = Collections.singletonList(configParameter);
            }
            catch (IOException e) {
                throw new ConfiguratorException("Failed to read from URL: " + configParameter, e);
            }
        }
        catch (MalformedURLException e) {
            throw new ConfiguratorException("Failed to read from url. Url is malformed: " + configParameter, e);
        }
    }

    private void _configureWithPaths(String configParameter) throws ConfiguratorException {
        List<Path> configs = this.configs(configParameter);
        this.sources = configs.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
        for (Map.Entry entry : configs.stream().flatMap(ConfigurationAsCode::entries).collect(Collectors.toList())) {
            ConfigurationAsCode.configureWith(entry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> configs(String path) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher(YAML_FILES_PATTERN);
        try (Stream<Path> configs = Files.find(Paths.get(StringUtils.defaultIfBlank((String)path, (String)DEFAULT_JENKINS_YAML_PATH), new String[0]), Integer.MAX_VALUE, (next, attrs) -> attrs.isRegularFile() && matcher.matches((Path)next), new FileVisitOption[0]);){
            List<Path> list = configs.collect(Collectors.toList());
            return list;
        }
        catch (NoSuchFileException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new IllegalStateException("failed config scan for " + path, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Stream<? extends Map.Entry<String, Object>> entries(Path config) {
        try (BufferedReader reader = Files.newBufferedReader(config);){
            Stream<? extends Map.Entry<String, Object>> stream = ConfigurationAsCode.entries(reader);
            return stream;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Stream<? extends Map.Entry<String, Object>> entries(Reader config) {
        return ((Map)new Yaml().loadAs(config, Map.class)).entrySet().stream();
    }

    public static void configureWith(Map.Entry<String, Object> entry) throws ConfiguratorException {
        RootElementConfigurator configurator = Configurator.lookupRootElement(entry.getKey());
        if (configurator == null) {
            throw new ConfiguratorException(String.format("no configurator for root element <%s>", entry.getKey()));
        }
        try {
            configurator.configure(entry.getValue());
        }
        catch (ConfiguratorException e) {
            throw new ConfiguratorException(configurator, String.format("error configuring <%s> with <%s> configurator", entry.getKey(), configurator.getName()), e);
        }
    }

    public static ConfigurationAsCode get() {
        return (ConfigurationAsCode)((Object)Jenkins.getInstance().getExtensionList(ConfigurationAsCode.class).get(0));
    }

    public Collection<?> getRootConfigurators() {
        return new LinkedHashSet<RootElementConfigurator>(RootElementConfigurator.all());
    }

    public Collection<?> getConfigurators() {
        List<RootElementConfigurator> roots = RootElementConfigurator.all();
        LinkedHashSet<Object> elements = new LinkedHashSet<Object>(roots);
        for (RootElementConfigurator root : roots) {
            this.listElements(elements, root.describe());
        }
        return elements;
    }

    private void listElements(Set<Object> elements, Set<Attribute> attributes) {
        attributes.stream().map(Attribute::getType).map(Configurator::lookup).filter(Objects::nonNull).forEach(configurator -> {
            elements.addAll(configurator.getConfigurators());
            this.listElements(elements, configurator.describe());
        });
    }
}

