/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import com.google.gson.JsonObject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.jenkinsci.plugins.codefresh.CFGlobalConfig;
import org.jenkinsci.plugins.codefresh.CFPipeline;
import org.jenkinsci.plugins.codefresh.CFProfile;
import org.jenkinsci.plugins.codefresh.CFVariable;
import org.jenkinsci.plugins.codefresh.CodefreshBuildBadgeAction;
import org.jenkinsci.plugins.codefresh.CodefreshEnvVarAction;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CodefreshPipelineBuilder
extends Builder {
    private final String cfPipeline;
    private final boolean selectPipeline;
    private final boolean setCFVars;
    private final String cfBranch;
    private List<CFVariable> cfVars;

    @DataBoundConstructor
    public CodefreshPipelineBuilder(SelectPipeline selectPipeline, SetCFVars setCFVars) {
        if (selectPipeline != null) {
            this.cfPipeline = selectPipeline.cfPipeline;
            this.cfBranch = selectPipeline.cfBranch;
            this.selectPipeline = true;
        } else {
            this.selectPipeline = false;
            this.cfPipeline = null;
            this.cfBranch = "";
        }
        if (setCFVars != null) {
            this.setCFVars = true;
            this.cfVars = setCFVars.vars;
        } else {
            this.setCFVars = false;
            this.cfVars = null;
        }
    }

    public String getCfPipeline() {
        return this.cfPipeline;
    }

    public String getCfBranch() {
        return this.cfBranch;
    }

    public List<CFVariable> getCfVars() {
        return this.cfVars;
    }

    public boolean isSelectPipeline() {
        return this.selectPipeline;
    }

    public boolean isSetCFVars() {
        return this.setCFVars;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        CFProfile profile = null;
        CFGlobalConfig config = CFGlobalConfig.get();
        try {
            profile = new CFProfile(config.getCfUser(), config.getCfToken(), config.getCfUrl(), false);
        }
        catch (NullPointerException ne) {
            listener.getLogger().println("Couldn't get Codefresh profile details. Please check your system configuration.");
            return false;
        }
        String serviceId = "";
        String gitPath = "";
        String branch = "";
        CFApi api = new CFApi();
        String serviceName = this.getCfPipeline();
        if (serviceName == null) {
            SCM scm = build.getProject().getScm();
            if (!(scm instanceof GitSCM)) {
                listener.getLogger().println("Codefresh: you've specified you want to run a Codefresh pipeline,\n but we didn't find any git repository defined or service name specified for the build.\nAre you sure that's what you meant?");
                return false;
            }
            GitSCM gitSCM = (GitSCM)scm;
            branch = ((BranchSpec)gitSCM.getBranches().get(0)).getName().replaceFirst("\\*\\/", "");
            listener.getLogger().println("\nBranch " + branch + " detected.");
            RemoteConfig remote = (RemoteConfig)gitSCM.getRepositories().get(0);
            URIish uri = (URIish)remote.getURIs().get(0);
            gitPath = uri.getPath();
            serviceName = gitPath.split("/")[2].split("\\.")[0];
            serviceId = profile.getServiceIdByPath(gitPath);
            if (serviceId == null) {
                listener.getLogger().println("\nUser " + config.getCfUser() + " has no Codefresh pipeline defined for url " + gitPath + ".\n Exiting.");
                return false;
            }
        } else {
            serviceId = profile.getServiceIdByName(this.cfPipeline);
            branch = this.cfBranch;
            if (serviceId == null) {
                listener.getLogger().println("\nPipeline Id not found for " + this.cfPipeline + ".\n Exiting.");
                return false;
            }
        }
        listener.getLogger().println("\nTriggering Codefresh pipeline. Pipeline name: " + serviceName + ".\n");
        String buildId = api.startBuild(serviceId, branch, this.cfVars);
        JsonObject process = api.getProcess(buildId);
        String status = process.get("status").getAsString();
        String progressUrl = api.getBuildUrl(buildId);
        while (status.equals("pending") || status.equals("running") || status.equals("elected")) {
            listener.getLogger().println("Codefresh pipeline " + status + " - " + progressUrl + "\n Waiting 5 seconds...");
            Thread.sleep(5000L);
            status = api.getProcess(buildId).get("status").getAsString();
        }
        listener.getLogger().print(api.getFinalLogs(api.getProcess(buildId).get("progress").getAsString() + "\n"));
        switch (status) {
            case "success": {
                build.addAction((Action)new CodefreshBuildBadgeAction(progressUrl, status, "Pipeline"));
                build.addAction((Action)new CodefreshEnvVarAction("CODEFRESH_BUILD_URL", progressUrl));
                listener.getLogger().println("\n\nCodefresh build successfull!");
                break;
            }
            case "error": {
                build.addAction((Action)new CodefreshBuildBadgeAction(progressUrl, status, "Pipeline"));
                listener.getLogger().println("Codefresh build failed!");
                return false;
            }
            default: {
                build.addAction((Action)new CodefreshBuildBadgeAction(progressUrl, status, "Pipeline"));
                listener.getLogger().println("Codefresh build exited with status " + status + ".");
                return false;
            }
        }
        return true;
    }

    public boolean performStep(Run run, TaskListener listener) throws IOException, InterruptedException {
        CFGlobalConfig config = CFGlobalConfig.get();
        CFProfile profile = new CFProfile(config.getCfUser(), config.getCfToken(), config.getCfUrl(), false);
        String serviceId = "";
        String gitPath = "";
        String branch = "";
        CFApi api = new CFApi();
        String serviceName = this.getCfPipeline();
        if (serviceName == null) {
            listener.getLogger().println("\nUser " + config.getCfUser() + "has no Codefresh pipeline defined for url " + gitPath + ".\n Exiting.");
            return false;
        }
        serviceId = profile.getServiceIdByName(this.cfPipeline);
        branch = this.cfBranch;
        if (serviceId == null) {
            listener.getLogger().println("\nPipeline Id not found for " + this.cfPipeline + ".\n Exiting.");
            return false;
        }
        listener.getLogger().println("\nTriggering Codefresh build. Pipeline: " + serviceName + ".\n");
        String buildId = api.startBuild(serviceId, branch, this.cfVars);
        JsonObject process = api.getProcess(buildId);
        String status = process.get("status").getAsString();
        String progressUrl = api.getBuildUrl(buildId);
        Integer timer = 0;
        while (status.equals("pending") || status.equals("running") || status.equals("elected")) {
            listener.getLogger().println("Codefresh build " + status + " - " + progressUrl + "\n");
            Thread.sleep(5000L);
            timer = timer + 5000;
            status = api.getProcess(buildId).get("status").getAsString();
        }
        String time = String.format("%02d min, %02d sec", TimeUnit.MILLISECONDS.toMinutes(timer.intValue()), TimeUnit.MILLISECONDS.toSeconds(timer.intValue()));
        listener.getLogger().println("Codefresh build finished. Duration: " + time);
        listener.getLogger().print(api.getFinalLogs(api.getProcess(buildId).get("progress").getAsString() + "\n"));
        switch (status) {
            case "success": {
                run.addAction((Action)new CodefreshBuildBadgeAction(progressUrl, status, "Build"));
                listener.getLogger().println("\n\nCodefresh build successfull!");
                break;
            }
            case "error": {
                run.addAction((Action)new CodefreshBuildBadgeAction(progressUrl, status, "Build"));
                listener.getLogger().println("Codefresh build failed!");
                return false;
            }
            default: {
                run.addAction((Action)new CodefreshBuildBadgeAction(progressUrl, status, "Build"));
                listener.getLogger().println("Codefresh build exited with status " + status + ".");
                return false;
            }
        }
        return true;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    public static final class Descriptor
    extends BuildStepDescriptor<Builder> {
        private CFApi api;

        public Descriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Run Codefresh Pipeline";
        }

        public ListBoxModel doFillCfPipelineItems(@QueryParameter(value="cfPipeline") String cfPipeline) throws IOException, MalformedURLException {
            ListBoxModel items = new ListBoxModel();
            Object cfUrl = null;
            this.api = new CFApi();
            for (CFPipeline srv : this.api.getPipelines()) {
                String name = srv.getName();
                items.add((Object)new ListBoxModel.Option(name, name, cfPipeline.equals(name)));
            }
            return items;
        }
    }

    public static class SetCFVars {
        private List<CFVariable> vars;

        @DataBoundConstructor
        public SetCFVars(List<CFVariable> vars) {
            this.vars = vars;
        }
    }

    public static class SelectPipeline {
        private final String cfPipeline;
        private final String cfBranch;

        @DataBoundConstructor
        public SelectPipeline(String cfPipeline, String cfBranch) {
            this.cfPipeline = cfPipeline;
            this.cfBranch = cfBranch;
        }
    }
}

