/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import com.google.gson.JsonObject;
import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.jenkinsci.plugins.codefresh.CFComposition;
import org.jenkinsci.plugins.codefresh.CFGlobalConfig;
import org.jenkinsci.plugins.codefresh.CFProfile;
import org.jenkinsci.plugins.codefresh.CFVariable;
import org.jenkinsci.plugins.codefresh.CodefreshBuildBadgeAction;
import org.jenkinsci.plugins.codefresh.CodefreshEnvVarAction;
import org.jenkinsci.plugins.codefresh.CodefreshPipelineStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CFLaunchBuilder
extends Builder {
    private final String cfComposition;
    private final List<CFVariable> cfVars;
    private final boolean setCFVars;

    @DataBoundConstructor
    public CFLaunchBuilder(String cfComposition, SetCFVars setCFVars) {
        this.cfComposition = cfComposition;
        if (setCFVars != null) {
            this.setCFVars = true;
            this.cfVars = setCFVars.vars;
        } else {
            this.setCFVars = false;
            this.cfVars = null;
        }
    }

    public List<CFVariable> getCfVars() {
        return this.cfVars;
    }

    public boolean isSetCFVars() {
        return this.setCFVars;
    }

    public String getCfComposition() {
        return this.cfComposition;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        CFProfile profile = null;
        CFGlobalConfig config = CFGlobalConfig.get();
        try {
            profile = new CFProfile(config.getCfUser(), config.getCfToken(), config.getCfUrl(), false);
        }
        catch (NullPointerException ne) {
            listener.getLogger().println("Couldn't get Codefresh profile details. Please check your system configuration.");
            return false;
        }
        CFApi api = new CFApi(config.getCfToken(), config.getCfUrl(), config.isSelfSignedCert());
        try {
            listener.getLogger().println("*******\n");
            String compositionId = profile.getCompositionIdByName(this.cfComposition);
            String launchId = api.launchComposition(compositionId, this.cfVars);
            JsonObject process = api.getProcess(launchId);
            String processUrl = api.getBuildUrl(launchId);
            String status = process.get("status").getAsString();
            while (status.equals("pending") || status.equals("running") || status.equals("elected")) {
                listener.getLogger().println("Launching Codefresh composition environment: " + this.cfComposition + ".\n Waiting 5 seconds...");
                Thread.sleep(5000L);
                status = api.getProcess(launchId).get("status").getAsString();
            }
            listener.getLogger().print(api.getFinalLogs(api.getProcess(launchId).get("progress").getAsString() + "\n"));
            switch (status) {
                case "success": {
                    String envUrl = api.getEnvUrl(api.getProcess(launchId));
                    build.addAction((Action)new CodefreshBuildBadgeAction(envUrl, status, "Environment"));
                    build.addAction((Action)new CodefreshEnvVarAction("CODEFRESH_ENV_URL", envUrl));
                    listener.getLogger().println("\nCodefresh environment launched successfully - " + envUrl);
                    return true;
                }
                case "error": {
                    build.addAction((Action)new CodefreshBuildBadgeAction(processUrl, status, "Environment"));
                    listener.getLogger().println("\nCodefresh enironment launch failed!");
                    return false;
                }
            }
            build.addAction((Action)new CodefreshBuildBadgeAction(processUrl, status, "Environment"));
            listener.getLogger().println("\n Codefresh environment launch exited with status " + status + ".");
            return false;
        }
        catch (Exception ex) {
            Logger.getLogger(CFLaunchBuilder.class.getName()).log(Level.SEVERE, null, ex);
            listener.getLogger().println("\nCodefresh environment launch failed with exception: " + ex.getMessage() + ".");
            build.addAction((Action)new CodefreshBuildBadgeAction("", "error", "Environment"));
            return false;
        }
    }

    public boolean performStep(Run run, TaskListener listener) throws IOException, InterruptedException {
        CFGlobalConfig config = CFGlobalConfig.get();
        CFProfile profile = new CFProfile(config.getCfUser(), config.getCfToken(), config.getCfUrl(), false);
        CFApi api = new CFApi(config.getCfToken(), config.getCfUrl(), config.isSelfSignedCert());
        try {
            listener.getLogger().println("*******\n");
            String compositionId = profile.getCompositionIdByName(this.cfComposition);
            if (compositionId == null) {
                throw new AbortException("Composition " + this.cfComposition + " not found. Exiting");
            }
            String launchId = api.launchComposition(compositionId, this.cfVars);
            JsonObject process = api.getProcess(launchId);
            String status = process.get("status").getAsString();
            String processUrl = api.getBuildUrl(launchId);
            while (status.equals("pending") || status.equals("running") || status.equals("elected")) {
                listener.getLogger().println("Launching Codefresh composition environment: " + this.cfComposition + ".\n Waiting 5 seconds...");
                Thread.sleep(5000L);
                status = api.getProcess(launchId).get("status").getAsString();
            }
            listener.getLogger().print(api.getFinalLogs(api.getProcess(launchId).get("progress").getAsString() + "\n"));
            switch (status) {
                case "success": {
                    String envUrl = api.getEnvUrl(api.getProcess(launchId));
                    run.addAction((Action)new CodefreshBuildBadgeAction(envUrl, status, "Environment"));
                    listener.getLogger().println("Codefresh environment launched successfully - " + envUrl);
                    return true;
                }
                case "error": {
                    run.addAction((Action)new CodefreshBuildBadgeAction(processUrl, status, "Environment"));
                    listener.getLogger().println("Codefresh enironment launch failed!");
                    return false;
                }
            }
            run.addAction((Action)new CodefreshBuildBadgeAction(processUrl, status, "Environment"));
            listener.getLogger().println("Codefresh environment launch exited with status " + status + ".");
            return false;
        }
        catch (Exception ex) {
            Logger.getLogger(CFLaunchBuilder.class.getName()).log(Level.SEVERE, null, ex);
            listener.getLogger().println("Codefresh environment launch failed with exception: " + ex.getMessage() + ".");
            run.addAction((Action)new CodefreshBuildBadgeAction("", "error", "Environment"));
            throw new AbortException(ex.getMessage());
        }
    }

    @Extension
    public static final class Descriptor
    extends BuildStepDescriptor<Builder> {
        private CFApi api;

        public Descriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Launch Codefresh Composition";
        }

        public ListBoxModel doFillCfCompositionItems(@QueryParameter(value="cfComposition") String cfComposition) throws IOException, MalformedURLException {
            String cfToken;
            ListBoxModel items = new ListBoxModel();
            String cfUrl = null;
            boolean selfSignedCert = false;
            try {
                CFGlobalConfig config = CFGlobalConfig.get();
                cfToken = config.getCfToken().getPlainText();
                cfUrl = config.getCfUrl();
                selfSignedCert = config.isSelfSignedCert();
            }
            catch (NullPointerException ne) {
                Logger.getLogger(CodefreshPipelineStep.class.getName()).log(Level.SEVERE, null, ne);
                return null;
            }
            this.api = new CFApi(Secret.fromString((String)cfToken), cfUrl, selfSignedCert);
            for (CFComposition comp : this.api.getCompositions()) {
                String name = comp.getName();
                items.add((Object)new ListBoxModel.Option(name, name, cfComposition.equals(name)));
            }
            return items;
        }
    }

    public static class SetCFVars {
        private final List<CFVariable> vars;

        @DataBoundConstructor
        public SetCFVars(List<CFVariable> vars) {
            this.vars = vars;
        }
    }
}

