/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import jenkins.YesNoMaybe;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.codefresh.CFApi;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(dynamicLoadable=YesNoMaybe.YES)
public class CFGlobalConfig
extends GlobalConfiguration {
    private String cfUser;
    private Secret cfToken;
    private CFApi api;
    private String cfUrl;
    private boolean selfSignedCert;

    public static CFGlobalConfig get() {
        CFGlobalConfig config;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (config = (CFGlobalConfig)jenkins.getDescriptorByType(CFGlobalConfig.class)) != null) {
            return config;
        }
        return null;
    }

    public CFGlobalConfig() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.cfUser = formData.getString("cfUser");
        this.cfToken = Secret.fromString((String)formData.getString("cfToken"));
        this.cfUrl = formData.getString("cfUrl");
        this.selfSignedCert = formData.getBoolean("selfSignedCert");
        this.save();
        return super.configure(req, formData);
    }

    public String getCfUser() {
        return this.cfUser;
    }

    public String getCfUrl() {
        return this.cfUrl;
    }

    public Secret getCfToken() {
        return this.cfToken;
    }

    public boolean isSelfSignedCert() {
        return this.selfSignedCert;
    }

    public FormValidation doTestConnection(@QueryParameter(value="cfUser") String cfUser, @QueryParameter(value="cfToken") String cfToken, @QueryParameter(value="cfUrl") String cfUrl, @QueryParameter(value="selfSignedCert") boolean selfSignedCert) throws IOException {
        String userName = null;
        try {
            this.api = new CFApi(Secret.fromString((String)cfToken), cfUrl, selfSignedCert);
            userName = this.api.getUser();
        }
        catch (IOException e) {
            return FormValidation.error((String)("Couldn't connect. Please check your token and internet connection.\n" + e.getMessage()));
        }
        if (userName != null) {
            if (userName.equals(cfUser)) {
                return FormValidation.ok((String)"Success");
            }
            return FormValidation.error((String)"Username and token don't match");
        }
        return FormValidation.error((String)"Couldn't connect. Please check your token and internet connection.");
    }
}

