/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codefresh;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.codefresh.CFComposition;
import org.jenkinsci.plugins.codefresh.CFGlobalConfig;
import org.jenkinsci.plugins.codefresh.CFPipeline;
import org.jenkinsci.plugins.codefresh.CFVariable;
import org.jsoup.Jsoup;

public class CFApi {
    private SSLSocketFactory sf = null;
    private String cfUrl = "https://g.codefresh.io/api";
    private Secret cfToken;
    private boolean https = false;
    private TrustManager[] trustAllCerts;
    private static final Logger LOGGER = Logger.getLogger(CFApi.class.getName());
    private static final Integer PIPELINE_BATCH_SIZE = 50;

    public CFApi(Secret cfToken, String cfUrl, boolean selfSignedCert) throws MalformedURLException, IOException {
        this.cfToken = cfToken;
        this.cfUrl = cfUrl + "/api";
        if (cfUrl.contains("https")) {
            this.secureContext(selfSignedCert);
        }
    }

    public CFApi() throws MalformedURLException, IOException {
        CFGlobalConfig config = CFGlobalConfig.get();
        if (config == null) {
            LOGGER.log(Level.SEVERE, "Couldn't get Codefresh configuration. Did you define one?");
            throw new IOException();
        }
        this.cfToken = config.getCfToken();
        this.cfUrl = config.getCfUrl() + "/api";
        if (this.cfUrl.contains("https")) {
            this.secureContext(config.isSelfSignedCert());
        }
    }

    public List<CFPipeline> getPipelines() throws IOException {
        List<CFPipeline> batch;
        ArrayList<CFPipeline> pipelines = new ArrayList<CFPipeline>();
        int offset = 0;
        int limit = PIPELINE_BATCH_SIZE;
        while (!(batch = this.getPipelines(offset, limit)).isEmpty()) {
            pipelines.addAll(batch);
            LOGGER.info("Load pipelines batch from " + (offset += PIPELINE_BATCH_SIZE.intValue()) + " to " + (limit += PIPELINE_BATCH_SIZE.intValue()));
        }
        return pipelines;
    }

    public List<CFPipeline> getPipelines(int offset, int limit) throws IOException {
        HttpURLConnection conn = this.getConnection(String.format(this.cfUrl + "/pipelines?offset=%d&limit=%d", offset, limit));
        ArrayList<CFPipeline> services = new ArrayList<CFPipeline>();
        JsonParser parser = new JsonParser();
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        if (parser.parse(jsonString).getAsJsonObject().get("docs") != null) {
            JsonArray serviceList = new JsonParser().parse(jsonString).getAsJsonObject().get("docs").getAsJsonArray();
            for (JsonElement service : serviceList) {
                String name = service.getAsJsonObject().getAsJsonObject("metadata").get("name").getAsString();
                String id = URLEncoder.encode(name, "UTF-8");
                services.add(new CFPipeline(this.cfToken, name, id));
            }
        }
        return services;
    }

    public String getUser() throws MalformedURLException, IOException {
        String userUrl = this.cfUrl + "/user";
        HttpURLConnection conn = this.getConnection(userUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        JsonObject user = new JsonParser().parse(jsonString).getAsJsonObject();
        String userName = user.get("userName").getAsString();
        return userName;
    }

    public String startBuild(String serviceId, String branch, List<CFVariable> vars) throws MalformedURLException, IOException {
        String buildUrl = this.cfUrl + "/builds/" + serviceId;
        String buildOptions = "";
        HttpURLConnection conn = this.getConnection(buildUrl);
        conn.setRequestMethod("POST");
        if (branch.isEmpty()) {
            branch = "master";
        }
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "jenkins-plugin1.7");
        conn.setRequestProperty("Codefresh-Agent", "jenkins-plugin");
        JsonObject options = new JsonObject();
        options.addProperty("branch", branch);
        if (vars != null) {
            JsonObject var2json = new JsonObject();
            for (CFVariable var : vars) {
                var2json.addProperty(var.variable, var.value);
            }
            options.add("variables", (JsonElement)var2json);
        }
        buildOptions = options.toString();
        OutputStreamWriter outs = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
        Object object = null;
        try {
            outs.write(buildOptions);
            outs.flush();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (outs != null) {
                if (object != null) {
                    try {
                        outs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    outs.close();
                }
            }
        }
        InputStream is = conn.getInputStream();
        return IOUtils.toString((InputStream)is).replace("\"", "");
    }

    public HttpURLConnection getConnection(String urlString) throws MalformedURLException, IOException {
        if (urlString.isEmpty()) {
            urlString = this.cfUrl;
        }
        URL connUrl = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)connUrl.openConnection();
        conn.setRequestProperty("x-access-token", this.cfToken.getPlainText());
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setInstanceFollowRedirects(true);
        if (this.https) {
            HttpsURLConnection.setFollowRedirects(true);
            return (HttpsURLConnection)conn;
        }
        return conn;
    }

    String getBuildProgress(String buildId) throws IOException {
        String buildUrl = this.cfUrl + "/builds/" + buildId;
        HttpURLConnection conn = this.getConnection(buildUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        JsonObject build = new JsonParser().parse(jsonString).getAsJsonObject();
        String progress = build.get("progress_id").getAsString();
        return progress;
    }

    JsonObject getProcess(String processId) throws IOException {
        String progressUrl = this.cfUrl + "/builds/" + processId;
        HttpURLConnection conn = this.getConnection(progressUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        JsonObject progress = new JsonParser().parse(jsonString).getAsJsonObject();
        return progress;
    }

    String getBuildUrl(String progressId) throws IOException {
        String buildUrl = this.cfUrl.substring(0, this.cfUrl.lastIndexOf(47)) + "/process/" + progressId;
        return buildUrl;
    }

    String launchService(String serviceId, String repoOwner, String repoName, String branch) throws Exception {
        String launchUrl = this.cfUrl + "/runtime/testit";
        String launchOptions = "";
        HttpURLConnection conn = this.getConnection(launchUrl);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "jenkins-plugin1.7");
        conn.setRequestProperty("Codefresh-Agent", "jenkins-plugin");
        JsonObject options = new JsonObject();
        options.addProperty("repoOwner", repoOwner);
        options.addProperty("repoName", repoName);
        options.addProperty("branch", branch);
        launchOptions = options.toString();
        try (OutputStreamWriter outs = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");){
            outs.write(launchOptions);
            outs.flush();
        }
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        JsonObject process = new JsonParser().parse(jsonString).getAsJsonObject();
        String processId = process.get("id").getAsString();
        return processId;
    }

    String launchComposition(String compositionId, List<CFVariable> vars) throws Exception {
        String launchUrl = this.cfUrl + "/compositions/" + compositionId + "/run";
        String launchOptions = "";
        HttpURLConnection conn = this.getConnection(launchUrl);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "jenkins-plugin1.7");
        conn.setRequestProperty("Codefresh-Agent", "jenkins-plugin");
        JsonObject options = new JsonObject();
        if (vars != null) {
            JsonObject var2json = new JsonObject();
            for (CFVariable cFVariable : vars) {
                var2json.addProperty(cFVariable.variable, cFVariable.value);
            }
            options.add("compositionVariables", (JsonElement)var2json);
        }
        launchOptions = options.toString();
        OutputStreamWriter outs = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
        Object object = null;
        try {
            outs.write(launchOptions);
            outs.flush();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (outs != null) {
                if (object != null) {
                    try {
                        outs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    outs.close();
                }
            }
        }
        String processId = null;
        try {
            Throwable throwable = null;
            try (InputStream is = conn.getInputStream();){
                String jsonString = IOUtils.toString((InputStream)is);
                JsonObject process = new JsonParser().parse(jsonString).getAsJsonObject();
                processId = process.get("id").getAsString();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            InputStream inputStream = conn.getErrorStream();
            Throwable throwable = null;
            try {
                try {
                    String jsonString = IOUtils.toString((InputStream)inputStream);
                    JsonObject out = new JsonParser().parse(jsonString).getAsJsonObject();
                    String message = out.get("message").getAsString();
                    throw new IOException(message);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        inputStream.close();
                    }
                }
                throw throwable5;
            }
        }
        return processId;
    }

    String getEnvUrl(JsonObject process) throws IOException {
        String progressId = process.get("progress_id").getAsString();
        JsonArray environment = this.getEnvByProgressID(progressId);
        JsonArray instances = environment.get(0).getAsJsonObject().get("instances").getAsJsonArray();
        JsonObject Urls = instances.get(0).getAsJsonObject().get("urls").getAsJsonObject();
        JsonObject UrlObj = Urls.get("run").getAsJsonArray().get(0).getAsJsonObject();
        JsonObject http = UrlObj.getAsJsonObject("http");
        String envUrl = http.get("public").getAsString();
        return envUrl;
    }

    JsonArray getEnvByProgressID(String progressId) throws IOException {
        String progressUrl = this.cfUrl + "/environments?progress=" + progressId;
        HttpURLConnection conn = this.getConnection(progressUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        JsonArray environment = new JsonParser().parse(jsonString).getAsJsonArray();
        return environment;
    }

    String getEnvIdByProgressID(String progressId) throws IOException {
        JsonArray environment = this.getEnvByProgressID(progressId);
        String envId = environment.get(0).getAsJsonObject().get("_id").getAsString();
        return envId;
    }

    String getEnvIdByURL(String envURL) throws IOException {
        String getEnvsUrl = this.cfUrl + "/environments";
        HttpURLConnection conn = this.getConnection(getEnvsUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        String envId = "";
        JsonArray envList = new JsonParser().parse(jsonString).getAsJsonArray();
        for (int i = 0; i < envList.size(); ++i) {
            JsonObject environment = (JsonObject)envList.get(i);
            envId = environment.get("_id").getAsString();
            JsonArray instances = environment.get("instances").getAsJsonArray();
            for (int k = 0; k < instances.size(); ++k) {
                JsonArray urls = ((JsonObject)instances.get(k)).get("urls").getAsJsonObject().get("run").getAsJsonArray();
                String publicURL = urls.get(0).getAsJsonObject().get("http").getAsJsonObject().get("public").getAsString();
                if (!envURL.equals(publicURL)) continue;
                return envId;
            }
        }
        return envId;
    }

    String getFinalLogs(String progressId) throws IOException {
        String getLogsUrl = this.cfUrl + "/progress/download/" + progressId;
        HttpURLConnection conn = this.getConnection(getLogsUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String logsHtml = IOUtils.toString((InputStream)is);
        return Jsoup.parse((String)logsHtml).text();
    }

    public List<CFComposition> getCompositions() throws MalformedURLException, IOException {
        String compositionUrl = this.cfUrl + "/compositions";
        HttpURLConnection conn = this.getConnection(compositionUrl);
        ArrayList<CFComposition> compositions = new ArrayList<CFComposition>();
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        String jsonString = IOUtils.toString((InputStream)is);
        JsonArray compositionList = new JsonParser().parse(jsonString).getAsJsonArray();
        for (int i = 0; i < compositionList.size(); ++i) {
            JsonObject obj = (JsonObject)compositionList.get(i);
            compositions.add(new CFComposition(obj.get("name").getAsString(), obj.get("_id").getAsString()));
        }
        return compositions;
    }

    boolean terminateEnv(String envId) throws Exception {
        String terminateUrl = this.cfUrl + "/environments/" + envId + "/terminate";
        String launchOptions = "";
        HttpURLConnection conn = this.getConnection(terminateUrl);
        conn.setRequestMethod("GET");
        InputStream is = conn.getInputStream();
        return IOUtils.toString((InputStream)is).equals("terminated");
    }

    private void secureContext(boolean selfSignedCert) {
        this.https = true;
        this.trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, this.trustAllCerts, new SecureRandom());
            this.sf = sc.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sf);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        if (selfSignedCert) {
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return true;
                }
            });
        }
    }
}

