/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.codedx.api.client.CodeDxClient;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.Project;
import hudson.AbortException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import org.jenkinsci.plugins.codedx.CodeDxPublisher;

public class ProjectResolver {
    PrintStream log;
    CodeDxClient client;

    public ProjectResolver(PrintStream log, CodeDxClient client) {
        this.log = log;
        this.client = client;
    }

    private int resolveSpecificProject(CodeDxPublisher.SpecificProject selection) throws IOException, CodeDxClientException {
        try {
            this.log.println("Using Specific Project ID");
            return Integer.parseInt(selection.getProjectId());
        }
        catch (NumberFormatException e) {
            throw new AbortException("Invalid project ID: " + selection.getProjectId());
        }
    }

    private int resolveNamedProject(CodeDxPublisher.NamedProject selection, String newProjectDefaultBranch) throws IOException, CodeDxClientException {
        this.log.println("Using Named Project");
        String projectName = selection.getProjectName();
        if (projectName == null || projectName.trim().isEmpty()) {
            throw new AbortException("Project name was not specified.");
        }
        LinkedList<Project> matches = new LinkedList<Project>();
        this.log.println("Fetching list of projects");
        for (Project project : this.client.getProjects()) {
            if (!project.getName().equals(projectName)) continue;
            matches.add(project);
        }
        this.log.println(String.format("Found %d total projects", matches.size()));
        switch (matches.size()) {
            case 0: {
                this.log.println("Did not find any matching projects");
                if (selection.isAutoCreate()) {
                    this.log.println(String.format("Auto-create is enabled, creating project with default branch '%s'", newProjectDefaultBranch));
                    return this.client.createProject(projectName, newProjectDefaultBranch).getId();
                }
                this.log.println("Auto-create is NOT enabled");
                break;
            }
            case 1: {
                return ((Project)matches.get(0)).getId();
            }
        }
        throw new AbortException(String.format("Expected to find 1 project named '%s', but found %d.", projectName, matches.size()));
    }

    public int resolveProjectId(CodeDxPublisher.ProjectSelection selection, String newProjectDefaultBranch) throws IOException, CodeDxClientException {
        if (selection == null) {
            throw new NullPointerException("Project selection was 'null'");
        }
        if (selection instanceof CodeDxPublisher.SpecificProject) {
            return this.resolveSpecificProject((CodeDxPublisher.SpecificProject)selection);
        }
        if (selection instanceof CodeDxPublisher.NamedProject) {
            return this.resolveNamedProject((CodeDxPublisher.NamedProject)selection, newProjectDefaultBranch);
        }
        throw new UnsupportedOperationException("Unexpected project selection type");
    }
}

