/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.codedx.api.client.CodeDxClient;
import com.codedx.api.client.CodeDxClientException;
import com.codedx.api.client.Filter;
import com.codedx.api.client.ProjectContext;
import com.codedx.util.CodeDxVersion;
import hudson.model.Result;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import org.apache.http.client.ClientProtocolException;
import org.jenkinsci.plugins.codedx.BuildPolicyBehavior;

public class AnalysisResultChecker {
    private CodeDxClient client;
    private CodeDxVersion cdxVersion;
    private String failureSeverity;
    private String unstableSeverity;
    private Date newThreshold;
    private boolean failureOnlyNew;
    private boolean unstableOnlyNew;
    private BuildPolicyBehavior policyBehavior;
    private PrintStream logger;
    private ProjectContext project;

    public AnalysisResultChecker(CodeDxClient client, CodeDxVersion cdxVersion, String failureSeverity, String unstableSeverity, Date newThreshold, boolean failureOnlyNew, boolean unstableOnlyNew, BuildPolicyBehavior policyBehavior, ProjectContext project, PrintStream logger) {
        this.client = client;
        this.cdxVersion = cdxVersion;
        this.failureSeverity = failureSeverity;
        this.unstableSeverity = unstableSeverity;
        this.newThreshold = newThreshold;
        this.failureOnlyNew = failureOnlyNew;
        this.unstableOnlyNew = unstableOnlyNew;
        this.policyBehavior = policyBehavior;
        this.project = project;
        this.logger = logger;
        if (this.policyBehavior == null) {
            this.policyBehavior = BuildPolicyBehavior.Default;
        }
        if (this.policyBehavior != BuildPolicyBehavior.NoAction && cdxVersion.compareTo(CodeDxVersion.MIN_FOR_POLICIES) < 0) {
            logger.println("The discovered Code Dx version " + cdxVersion.toString() + " is older than the minimum required version for Policies (" + CodeDxVersion.MIN_FOR_POLICIES + "), policy-related options will be ignored.");
            this.policyBehavior = BuildPolicyBehavior.NoAction;
        }
    }

    public Result checkResult() throws ClientProtocolException, CodeDxClientException, IOException {
        if (this.policyBehavior != BuildPolicyBehavior.NoAction) {
            this.logger.println("Checking for build-breaking policy violations...");
            if (this.client.projectPolicyShouldBreakTheBuild(this.project)) {
                this.logger.println("Failure: At least one Policy is violated and set to 'Break build'");
                return this.policyBehavior.getEquivalentResult();
            }
        }
        this.logger.println("Checking for findings that indicate build failure...");
        if (!"None".equalsIgnoreCase(this.failureSeverity) && this.client.getFindingsCount(this.project, this.createFilter(this.failureSeverity, this.failureOnlyNew)) > 0) {
            this.logger.println(String.format("Failure: Code Dx reported %s or higher severity issues.", this.failureSeverity));
            return Result.FAILURE;
        }
        this.logger.println("Checking for findings that indicate unstable build.");
        if (!"None".equalsIgnoreCase(this.unstableSeverity) && this.client.getFindingsCount(this.project, this.createFilter(this.unstableSeverity, this.unstableOnlyNew)) > 0) {
            this.logger.println("Unstable!");
            return Result.UNSTABLE;
        }
        this.logger.println("CodeDx results indicate success!");
        return Result.SUCCESS;
    }

    private Filter createFilter(String minSeverity, boolean onlyNew) {
        Filter filter = new Filter();
        filter.setSeverity(this.getSeverities(minSeverity));
        filter.setNotStatus(new String[]{"false-positive", "fixed", "gone", "ignored", "mitigated"});
        if (onlyNew) {
            this.logger.println("Using the 'only consider new findings' option to decide build failure/instability.");
            if (this.cdxVersion.supportsTriageNew()) {
                this.logger.println("Code Dx version is " + this.cdxVersion + ": the 'New' status is available for filtering.");
                filter.setStatus(new String[]{"new"});
            } else {
                this.logger.println("Code Dx version is " + this.cdxVersion + ": using 'firstSeen' filter to decide 'new' findings");
                filter.setFirstSeen(new Filter.DateRange(this.newThreshold, new Date()));
            }
        }
        this.logger.println("Using filter: " + filter.toString());
        return filter;
    }

    private String[] getSeverities(String minSeverity) {
        String[] possibleSeverities = new String[]{"Info", "Low", "Medium", "High", "Critical", "Unspecified"};
        for (int i = 0; i < possibleSeverities.length; ++i) {
            if (!possibleSeverities[i].equalsIgnoreCase(minSeverity)) continue;
            return Arrays.copyOfRange(possibleSeverities, i, possibleSeverities.length);
        }
        return new String[0];
    }
}

