/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.codedx.CodeDxAreaRenderer;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.jenkinsci.plugins.codedx.model.StatisticGroup;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class CodeDxChartBuilder
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static Set<String> hiddenGroups = new HashSet<String>(){
        {
            this.add("Gone");
        }
    };

    private CodeDxChartBuilder() {
    }

    public static JFreeChart buildChart(CodeDxBuildAction action, int numBuildsInGraph, String statisticsName, Map<String, Color> colors) {
        CategoryDataset dataset = CodeDxChartBuilder.buildDataset(action, numBuildsInGraph, statisticsName);
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"Findings", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)true);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        List rows = dataset.getRowKeys();
        ArrayList<Color> colorList = new ArrayList<Color>();
        if (colors != null) {
            for (Object row : rows) {
                if (colors.containsKey(row.toString())) {
                    colorList.add(colors.get(row.toString()));
                    continue;
                }
                colorList.add(new Color(row.toString().hashCode()));
            }
        }
        if (colorList.size() == rows.size()) {
            plot.setRenderer((CategoryItemRenderer)new CodeDxAreaRenderer(colorList));
        } else {
            plot.setRenderer((CategoryItemRenderer)new CodeDxAreaRenderer(null));
        }
        ArrayList legendItems = new ArrayList();
        Iterator itr = plot.getLegendItems().iterator();
        while (itr.hasNext()) {
            legendItems.add(itr.next());
        }
        Collections.sort(legendItems, new Comparator<LegendItem>(){

            @Override
            public int compare(LegendItem lhs, LegendItem rhs) {
                return rhs.getSeriesKey().compareTo(lhs.getSeriesKey());
            }
        });
        LegendItemCollection newItems = new LegendItemCollection();
        for (LegendItem item : legendItems) {
            newItems.add(item);
        }
        plot.setFixedLegendItems(newItems);
        return chart;
    }

    private static List<CodeDxBuildAction> collectSuccessfulBuilds(CodeDxBuildAction lastAction, int maxNumBuilds) {
        ArrayList<CodeDxBuildAction> allBuildActions = new ArrayList<CodeDxBuildAction>();
        for (CodeDxBuildAction action = lastAction; action != null && (maxNumBuilds <= 1 || allBuildActions.size() < maxNumBuilds); action = action.getPreviousAction()) {
            CodeDxResult result = action.getResult();
            if (result == null) continue;
            allBuildActions.add(action);
        }
        return allBuildActions;
    }

    private static ChartUtil.NumberOnlyBuildLabel MakeBuildLabel(Run<?, ?> run, AbstractBuild<?, ?> build) {
        if (run != null) {
            return new ChartUtil.NumberOnlyBuildLabel(run);
        }
        if (build != null) {
            Class<ChartUtil.NumberOnlyBuildLabel> cls = ChartUtil.NumberOnlyBuildLabel.class;
            try {
                Constructor ctor = cls.getConstructor(AbstractBuild.class);
                return (ChartUtil.NumberOnlyBuildLabel)ctor.newInstance(build);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static CategoryDataset buildDataset(CodeDxBuildAction lastAction, int numBuildsInGraph, String statisticsName) {
        DataSetBuilder builder = new DataSetBuilder();
        List<CodeDxBuildAction> allBuildActions = CodeDxChartBuilder.collectSuccessfulBuilds(lastAction, numBuildsInGraph);
        Set<String> knownGroups = StatisticGroup.valuesForStatistic(statisticsName);
        for (CodeDxBuildAction action : allBuildActions) {
            knownGroups.addAll(action.getResult().getStatistics(statisticsName).getAllGroups());
        }
        for (CodeDxBuildAction action : allBuildActions) {
            ChartUtil.NumberOnlyBuildLabel buildLabel = CodeDxChartBuilder.MakeBuildLabel(action.getRun(), action.getBuild());
            CodeDxResult result = action.getResult();
            HashSet<String> remainingGroups = new HashSet<String>(knownGroups);
            for (CodeDxGroupStatistics groupStats : result.getStatistics(statisticsName).getStatistics()) {
                String statisticGroup = groupStats.getGroup();
                if (!hiddenGroups.contains(statisticGroup)) {
                    builder.add((Number)groupStats.getFindings(), (Comparable)((Object)statisticGroup), (Comparable)buildLabel);
                }
                remainingGroups.remove(statisticGroup);
            }
            for (String group : remainingGroups) {
                builder.add((Number)0, (Comparable)((Object)group), (Comparable)buildLabel);
            }
        }
        return builder.build();
    }
}

