/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CodeDxVersion
implements Comparable<CodeDxVersion> {
    public static final CodeDxVersion MAX_FOR_NEW_STATUS = CodeDxVersion.fromString("2.4.0");
    public static final CodeDxVersion MIN_FOR_ANALYSIS_NAMES = CodeDxVersion.fromString("2.4.0");
    private final int[] numbers;

    public static CodeDxVersion fromString(String version) {
        Pattern versionRegex = Pattern.compile("^(\\d+(?:\\.\\d+)*).*");
        Matcher versionMatcher = versionRegex.matcher(version);
        if (versionMatcher.matches()) {
            String matchedNumbers = versionMatcher.group(1);
            String[] rawNumbers = matchedNumbers.split("\\.");
            int[] numbers = new int[rawNumbers.length];
            for (int i = 0; i < rawNumbers.length; ++i) {
                numbers[i] = Integer.valueOf(rawNumbers[i]);
            }
            return new CodeDxVersion(numbers);
        }
        throw new IllegalArgumentException("for input string \"" + version + "\"");
    }

    private CodeDxVersion(int[] numbers) {
        this.numbers = numbers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numbers.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(this.numbers[i]);
        }
        return sb.toString();
    }

    public boolean equals(Object thatObj) {
        if (thatObj instanceof CodeDxVersion) {
            CodeDxVersion that = (CodeDxVersion)thatObj;
            return this.compareTo(that) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(CodeDxVersion that) {
        int index = 0;
        int limit = Math.max(this.numbers.length, that.numbers.length);
        do {
            int nThat;
            int nThis = index < this.numbers.length ? this.numbers[index] : 0;
            int n = nThat = index < that.numbers.length ? that.numbers[index] : 0;
            if (nThis == nThat) continue;
            return nThis - nThat;
        } while (++index < limit);
        return 0;
    }
}

