/*
 * Decompiled with CFR 0.152.
 */
package com.secdec.codedx.security;

import com.secdec.codedx.security.CertificateAcceptance;
import com.secdec.codedx.security.ExtraCertManager;
import com.secdec.codedx.security.InvalidCertificateStrategy;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ReloadableX509TrustManager
implements X509TrustManager {
    final ExtraCertManager certManager;
    private final InvalidCertificateStrategy invalidCertStrat;
    private X509TrustManager tmDelegate;

    public ReloadableX509TrustManager(ExtraCertManager certManager, InvalidCertificateStrategy invalidCertStrat) throws GeneralSecurityException {
        this.certManager = certManager;
        this.invalidCertStrat = invalidCertStrat;
        this.reloadTrustManager();
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.tmDelegate.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.tmDelegate.checkServerTrusted(chain, authType);
        }
        catch (CertificateException cx) {
            X509Certificate cert = chain[0];
            CertificateAcceptance certAcceptance = this.invalidCertStrat.checkAcceptance(cert, cx);
            switch (certAcceptance) {
                case REJECT: {
                    throw cx;
                }
                case ACCEPT_TEMPORARILY: {
                    try {
                        this.certManager.addTemporaryCert(cert);
                        this.reloadTrustManager();
                    }
                    catch (IOException e) {
                        throw new CertificateException("Error handling temporary acceptance of the certificate", e);
                    }
                    catch (GeneralSecurityException e) {
                        throw new CertificateException("Error handling temporary acceptance of the certificate", e);
                    }
                    this.tmDelegate.checkServerTrusted(chain, authType);
                    break;
                }
                case ACCEPT_PERMANENTLY: {
                    try {
                        this.certManager.addPermanentCert(cert);
                        this.reloadTrustManager();
                    }
                    catch (IOException e) {
                        throw new CertificateException("Error handling permanent acceptance of the certificate", e);
                    }
                    catch (GeneralSecurityException e) {
                        throw new CertificateException("Error handling permanent acceptance of the certificate", e);
                    }
                    this.tmDelegate.checkServerTrusted(chain, authType);
                }
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.tmDelegate.getAcceptedIssuers();
    }

    void reloadTrustManager() throws GeneralSecurityException {
        TrustManager[] tms;
        KeyStore ks = this.certManager.asKeyStore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.tmDelegate = (X509TrustManager)tm;
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }
}

