/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codedx;

import com.secdec.codedx.api.client.CodeDxClient;
import com.secdec.codedx.api.client.CodeDxClientException;
import com.secdec.codedx.api.client.CodeDxRepeatingClient;
import com.secdec.codedx.api.client.CountGroup;
import com.secdec.codedx.api.client.Filter;
import com.secdec.codedx.api.client.Project;
import com.secdec.codedx.api.client.StartAnalysisResponse;
import com.secdec.codedx.api.client.TriageStatus;
import com.secdec.codedx.security.JenkinsSSLConnectionSocketFactoryFactory;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jenkinsci.plugins.codedx.AnalysisResultChecker;
import org.jenkinsci.plugins.codedx.AnalysisResultConfiguration;
import org.jenkinsci.plugins.codedx.Archiver;
import org.jenkinsci.plugins.codedx.CodeDxBuildAction;
import org.jenkinsci.plugins.codedx.CodeDxProjectAction;
import org.jenkinsci.plugins.codedx.CodeDxResult;
import org.jenkinsci.plugins.codedx.Util;
import org.jenkinsci.plugins.codedx.model.CodeDxGroupStatistics;
import org.jenkinsci.plugins.codedx.model.CodeDxReportStatistics;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeDxPublisher
extends Recorder {
    private final String url;
    private final String key;
    private final String projectId;
    private final String sourceAndBinaryFiles;
    private final String toolOutputFiles;
    private final String excludedSourceAndBinaryFiles;
    private final AnalysisResultConfiguration analysisResultConfiguration;
    private final CodeDxClient client;
    private final String selfSignedCertificateFingerprint;

    @DataBoundConstructor
    public CodeDxPublisher(String url, String key, String projectId, String sourceAndBinaryFiles, String toolOutputFiles, String excludedSourceAndBinaryFiles, AnalysisResultConfiguration analysisResultConfiguration, String selfSignedCertificateFingerprint) {
        this.projectId = projectId;
        this.url = url;
        this.key = key;
        this.sourceAndBinaryFiles = sourceAndBinaryFiles;
        this.excludedSourceAndBinaryFiles = excludedSourceAndBinaryFiles;
        this.toolOutputFiles = toolOutputFiles;
        this.analysisResultConfiguration = analysisResultConfiguration;
        this.selfSignedCertificateFingerprint = selfSignedCertificateFingerprint;
        this.client = CodeDxPublisher.buildClient(url, key, selfSignedCertificateFingerprint);
    }

    public AnalysisResultConfiguration getAnalysisResultConfiguration() {
        return this.analysisResultConfiguration;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceAndBinaryFiles() {
        return this.sourceAndBinaryFiles;
    }

    public String getToolOutputFiles() {
        return this.toolOutputFiles;
    }

    public String getExcludedSourceAndBinaryFiles() {
        return this.excludedSourceAndBinaryFiles;
    }

    public String getSelfSignedCertificateFingerprint() {
        return this.selfSignedCertificateFingerprint;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        String latestUrl = null;
        if (this.projectId.length() != 0 && !this.projectId.equals("-1")) {
            latestUrl = this.client.buildLatestFindingsUrl(Integer.parseInt(this.projectId));
        }
        return new CodeDxProjectAction(project, this.analysisResultConfiguration, latestUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String[] files;
        ArrayList<InputStream> toSend = new ArrayList<InputStream>();
        listener.getLogger().println("Starting Code Dx Publish");
        if (this.projectId.length() == 0 || this.projectId.equals("-1")) {
            listener.getLogger().println("No project has been selected");
            return true;
        }
        listener.getLogger().println("Code Dx Project ID: " + this.projectId);
        listener.getLogger().println("Code Dx URL: " + this.url);
        listener.getLogger().println("Creating source/binary zip...");
        FilePath sourceAndBinaryZip = Archiver.Archive(build.getWorkspace(), Util.commaSeparatedToArray(this.sourceAndBinaryFiles), Util.commaSeparatedToArray(this.excludedSourceAndBinaryFiles), "source", listener.getLogger());
        if (sourceAndBinaryZip != null) {
            try {
                listener.getLogger().println("Adding source/binary zip...");
                toSend.add(sourceAndBinaryZip.read());
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to add source/binary zip.");
            }
        } else {
            listener.getLogger().println("No matching source/binary files.");
        }
        for (String file : files = Util.commaSeparatedToArray(this.toolOutputFiles)) {
            FilePath path;
            if (file.length() == 0 || !(path = build.getWorkspace().child(file)).exists()) continue;
            try {
                listener.getLogger().println("Add tool output file " + path.getRemote() + " to request.");
                toSend.add(path.read());
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to add tool output file: " + path);
            }
        }
        if (toSend.size() > 0) {
            CodeDxRepeatingClient repeatingClient = new CodeDxRepeatingClient(this.client, listener.getLogger());
            try {
                listener.getLogger().println("Sending analysis request");
                int projectIdInt = Integer.parseInt(this.projectId);
                StartAnalysisResponse response = repeatingClient.startAnalysis(Integer.parseInt(this.projectId), toSend.toArray(new InputStream[0]));
                listener.getLogger().println("Analysis request succeeded");
                if (this.analysisResultConfiguration == null) {
                    listener.getLogger().println("No need to wait for analysis to complete.  We are done here.");
                    boolean file = true;
                    return file;
                }
                listener.getLogger().println("Waiting for analysis to complete");
                String status = null;
                do {
                    Thread.sleep(3000L);
                    status = repeatingClient.getJobStatus(response.getJobId());
                    listener.getLogger().println("The STATUS IS: " + status);
                } while ("queued".equals(status) || "running".equals(status));
                if ("completed".equals(status)) {
                    listener.getLogger().println("Analysis succeeded");
                    listener.getLogger().println("Fetching severity counts");
                    Filter notGoneFilter = new Filter();
                    notGoneFilter.setNotStatus(new String[]{"gone"});
                    List<CountGroup> severityCounts = repeatingClient.getFindingsGroupedCounts(projectIdInt, notGoneFilter, "severity");
                    listener.getLogger().println("Got severity counts");
                    listener.getLogger().println("Fetching status counts");
                    Filter notAssignedFilter = new Filter();
                    notAssignedFilter.setStatus(new String[]{"escalated", "false-positive", "fixed", "ignored", "new", "unresolved"});
                    List<CountGroup> statusCounts = repeatingClient.getFindingsGroupedCounts(projectIdInt, notAssignedFilter, "status");
                    listener.getLogger().println("Got status counts");
                    Filter assignedFilter = new Filter();
                    assignedFilter.setStatus(new String[]{"assigned"});
                    listener.getLogger().println("Fetching assigned count");
                    int assignedCount = repeatingClient.getFindingsCount(projectIdInt, assignedFilter);
                    if (assignedCount > 0) {
                        CountGroup assignedGroup = new CountGroup();
                        assignedGroup.setName("Assigned");
                        assignedGroup.setCount(assignedCount);
                        statusCounts.add(assignedGroup);
                    }
                    listener.getLogger().println("Got assigned count");
                    HashMap<String, CodeDxReportStatistics> statMap = new HashMap<String, CodeDxReportStatistics>();
                    statMap.put("severity", this.createStatistics(severityCounts));
                    statMap.put("status", this.createStatistics(statusCounts));
                    CodeDxResult result = new CodeDxResult(statMap, build);
                    listener.getLogger().println("Adding CodeDx build action");
                    build.addAction((Action)new CodeDxBuildAction(build, result));
                    AnalysisResultChecker checker = new AnalysisResultChecker(repeatingClient, this.analysisResultConfiguration.getFailureSeverity(), this.analysisResultConfiguration.getUnstableSeverity(), this.analysisResultConfiguration.isFailureOnlyNew(), this.analysisResultConfiguration.isUnstableOnlyNew(), projectIdInt, listener.getLogger());
                    build.setResult(checker.checkResult());
                    boolean bl = true;
                    return bl;
                }
                listener.getLogger().println("Analysis status: " + status);
                boolean bl = false;
                return bl;
            }
            catch (NumberFormatException e) {
                listener.getLogger().println("Invalid project Id");
            }
            catch (CodeDxClientException e) {
                listener.getLogger().println("Fatal Error!");
                e.printStackTrace(listener.getLogger());
            }
            finally {
                sourceAndBinaryZip.delete();
            }
        } else {
            listener.getLogger().println("Nothing to send, this doesn't seem right! Please check your 'Code Dx > Source and Binary Files' configuration.");
        }
        return false;
    }

    public static CodeDxClient buildClient(String url, String key, String fingerprint) {
        CodeDxClient client = new CodeDxClient(url, key);
        try {
            if (fingerprint != null) {
                fingerprint = fingerprint.replaceAll("[^a-fA-F0-9]", "");
            }
            URL parsedUrl = new URL(url);
            SSLConnectionSocketFactory socketFactory = JenkinsSSLConnectionSocketFactoryFactory.getFactory(fingerprint, parsedUrl.getHost());
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
            client = new CodeDxClient(url, key, builder);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return client;
    }

    private String[] getUsers(Map<String, TriageStatus> assignedStatuses) {
        ArrayList<String> users = new ArrayList<String>();
        for (TriageStatus status : assignedStatuses.values()) {
            if (!status.getType().equals("user")) continue;
            users.add(status.getDisplay());
        }
        return users.toArray(new String[0]);
    }

    private CodeDxReportStatistics createStatistics(List<CountGroup> countGroups) {
        ArrayList<CodeDxGroupStatistics> groupStatsList = new ArrayList<CodeDxGroupStatistics>();
        for (CountGroup group : countGroups) {
            CodeDxGroupStatistics stats = new CodeDxGroupStatistics(group.getName(), group.getCount());
            groupStatsList.add(stats);
        }
        return new CodeDxReportStatistics(groupStatsList);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Publish to Code Dx";
        }

        public FormValidation doCheckProjectId(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a project. If none are shown above, then be sure that system settings are configured correctly.");
            }
            if (Integer.parseInt(value) == -1) {
                return FormValidation.error((String)"Failed to get available projects, please ensure systems settings are configured correctly.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckKey(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a Key.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String value, @QueryParameter String selfSignedCertificateFingerprint) throws IOException, ServletException {
            CodeDxClient client = CodeDxPublisher.buildClient(value, "", selfSignedCertificateFingerprint);
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a URL.");
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                return FormValidation.error((String)"Malformed URL");
            }
            if (value.toLowerCase().startsWith("http:")) {
                return FormValidation.warning((String)"HTTP is considered insecure, it is recommended that you use HTTPS.");
            }
            if (value.toLowerCase().startsWith("https:")) {
                block7: {
                    try {
                        client.getProjects();
                    }
                    catch (Exception e) {
                        if (!(e instanceof SSLHandshakeException)) break block7;
                        return FormValidation.warning((String)"The SSL Certificate presented by the server is invalid. If this is expected, please input an SHA1 Fingerprint in the \"Advanced\" option");
                    }
                }
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Invalid protocol, please use HTTPS or HTTP.");
        }

        public FormValidation doCheckSelfSignedCertificateFingerprint(@QueryParameter String value, @QueryParameter String url) {
            block3: {
                if (url != null && !url.isEmpty() && value != null && !value.isEmpty()) {
                    CodeDxClient client = CodeDxPublisher.buildClient(url, "", value);
                    try {
                        client.getProjects();
                    }
                    catch (Exception e) {
                        if (!(e instanceof SSLHandshakeException)) break block3;
                        return FormValidation.warning((String)"The fingerprint doesn't match the fingerprint of the certifcate presented by the server");
                    }
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSourceAndBinaryFiles(@QueryParameter String value, @QueryParameter String toolOutputFiles, @AncestorInPath AbstractProject project) {
            if (value.length() == 0) {
                if (toolOutputFiles.length() == 0) {
                    return FormValidation.error((String)"You must specify \"Tool Output Files\" and/or \"Source and Binary Files\"");
                }
                return FormValidation.warning((String)"It is recommended that at least source files are provided to Code Dx.");
            }
            return Util.checkCSVGlobMatches(value, project.getSomeWorkspace());
        }

        public FormValidation doCheckExcludedSourceAndBinaryFiles(@QueryParameter String value, @AncestorInPath AbstractProject project) {
            return Util.checkCSVGlobMatches(value, project.getSomeWorkspace());
        }

        public FormValidation doCheckToolOutputFiles(@QueryParameter String value, @QueryParameter String sourceAndBinaryFiles, @AncestorInPath AbstractProject project) {
            if (value.length() == 0 && sourceAndBinaryFiles.length() == 0) {
                return FormValidation.error((String)"You must specify \"Tool Output Files\" and/or \"Source and Binary Files\"");
            }
            return Util.checkCSVFileMatches(value, project.getSomeWorkspace());
        }

        public ListBoxModel doFillProjectIdItems(@QueryParameter String url, @QueryParameter String selfSignedCertificateFingerprint, @QueryParameter String key, @AncestorInPath AbstractProject project) {
            ListBoxModel listBox = new ListBoxModel();
            CodeDxClient client = CodeDxPublisher.buildClient(url, key, selfSignedCertificateFingerprint);
            try {
                List<Project> projects = client.getProjects();
                HashMap<String, Boolean> duplicates = new HashMap<String, Boolean>();
                for (Project proj : projects) {
                    if (!duplicates.containsKey(proj.getName())) {
                        duplicates.put(proj.getName(), false);
                        continue;
                    }
                    duplicates.put(proj.getName(), true);
                }
                for (Project proj : projects) {
                    if (!((Boolean)duplicates.get(proj.getName())).booleanValue()) {
                        listBox.add(proj.getName(), Integer.toString(proj.getId()));
                        continue;
                    }
                    listBox.add(proj.getName() + " (id:" + proj.getId() + ")", Integer.toString(proj.getId()));
                }
            }
            catch (Exception e) {
                listBox.add("", "-1");
            }
            return listBox;
        }

        public ListBoxModel doFillFailureSeverityItems() {
            return this.getSeverityItems();
        }

        public ListBoxModel doFillUnstableSeverityItems() {
            return this.getSeverityItems();
        }

        private ListBoxModel getSeverityItems() {
            ListBoxModel listBox = new ListBoxModel();
            listBox.add("None", "None");
            listBox.add("Info or Higher", "Info");
            listBox.add("Low or Higher", "Low");
            listBox.add("Medium or Higher", "Medium");
            listBox.add("High", "High");
            return listBox;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            System.out.println("Code Dx descriptor configure method");
            return super.configure(req, formData);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(req, formData);
        }
    }
}

