/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.cloudfoundryjenkins;

import com.hpe.cloudfoundryjenkins.AbstractCloudFoundryPushDescriptor;
import com.hpe.cloudfoundryjenkins.CloudFoundryPushTask;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CloudFoundryPushPublisher
extends Recorder {
    public String target;
    public String organization;
    public String cloudSpace;
    public String credentialsId;
    public String selfSigned;
    public boolean resetIfExists;
    public String pluginTimeout;
    public List<Service> servicesToCreate;
    public ManifestChoice manifestChoice;

    @DataBoundConstructor
    public CloudFoundryPushPublisher(String target, String organization, String cloudSpace, String credentialsId, String selfSigned, boolean resetIfExists, String pluginTimeout, List<Service> servicesToCreate, ManifestChoice manifestChoice) {
        this.target = target;
        this.organization = organization;
        this.cloudSpace = cloudSpace;
        this.credentialsId = credentialsId;
        this.selfSigned = selfSigned;
        this.resetIfExists = resetIfExists;
        if (pluginTimeout == null) {
            this.pluginTimeout = String.valueOf(120);
        } else {
            try {
                int i = Integer.parseInt(pluginTimeout);
                this.pluginTimeout = i <= 0 ? String.valueOf(120) : pluginTimeout;
            }
            catch (NumberFormatException ignored) {
                this.pluginTimeout = pluginTimeout;
            }
        }
        this.servicesToCreate = servicesToCreate == null ? new ArrayList<Service>() : servicesToCreate;
        this.manifestChoice = manifestChoice == null ? ManifestChoice.defaultManifestFileConfig() : manifestChoice;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        Result result = build.getResult();
        if (result != null && result.isWorseThan(Result.SUCCESS)) {
            return true;
        }
        CloudFoundryPushTask task = new CloudFoundryPushTask(this.target, this.organization, this.cloudSpace, this.credentialsId, this.selfSigned, this.pluginTimeout, this.servicesToCreate, this.manifestChoice);
        return task.perform(build.getWorkspace(), (Run)build, launcher, (TaskListener)listener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private Object readResolve() {
        if (this.servicesToCreate == null) {
            this.servicesToCreate = new ArrayList<Service>();
        }
        return this;
    }

    public boolean isResetIfExists() {
        return this.resetIfExists;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractCloudFoundryPushDescriptor<Publisher> {
    }

    public static class Service {
        public final String name;
        public final String type;
        public final String plan;
        public boolean resetService;

        @DataBoundConstructor
        public Service(String name, String type, String plan) {
            this.name = name;
            this.type = type;
            this.plan = plan;
        }

        public Service(String name, String type, String plan, boolean resetService) {
            this(name, type, plan);
            this.resetService = resetService;
        }

        @DataBoundSetter
        public void setResetService(boolean resetService) {
            this.resetService = resetService;
        }

        public boolean isResetService() {
            return this.resetService;
        }
    }

    public static class ServiceName {
        public final String name;

        @DataBoundConstructor
        public ServiceName(String name) {
            this.name = name;
        }
    }

    public static class EnvironmentVariable {
        public final String key;
        public final String value;

        @DataBoundConstructor
        public EnvironmentVariable(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class ManifestChoice {
        public String value = "manifestFile";
        public String manifestFile = "manifest.yml";
        public String appName;
        public String memory;
        public String hostname;
        public String instances;
        public String timeout;
        public String noRoute;
        public String appPath;
        public String buildpack;
        public String stack;
        public String command;
        public String domain;
        public List<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>();
        public List<ServiceName> servicesNames = new ArrayList<ServiceName>();

        public ManifestChoice(String value, String manifestFile, String appName, String memory, String hostname, String instances, String timeout, String noRoute, String appPath, String buildpack, String stack, String command, String domain, List<EnvironmentVariable> envVars, List<ServiceName> servicesNames) {
            this.value = value == null ? "manifestFile" : value;
            this.manifestFile = manifestFile == null || manifestFile.isEmpty() ? "manifest.yml" : manifestFile;
            this.appName = appName;
            this.memory = memory;
            this.hostname = hostname;
            this.instances = instances;
            this.timeout = timeout;
            this.noRoute = noRoute;
            this.appPath = appPath;
            this.buildpack = buildpack;
            this.stack = stack;
            this.command = command;
            this.domain = domain;
            this.envVars = envVars;
            this.servicesNames = servicesNames;
        }

        @DataBoundConstructor
        public ManifestChoice() {
        }

        public String getValue() {
            return this.value;
        }

        @DataBoundSetter
        public void setValue(String value) {
            this.value = value;
        }

        public String getManifestFile() {
            return this.manifestFile;
        }

        @DataBoundSetter
        public void setManifestFile(String manifestFile) {
            this.manifestFile = manifestFile;
        }

        public String getAppName() {
            return this.appName;
        }

        @DataBoundSetter
        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getMemory() {
            return this.memory;
        }

        @DataBoundSetter
        public void setMemory(String memory) {
            this.memory = memory;
        }

        public String getHostname() {
            return this.hostname;
        }

        @DataBoundSetter
        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public String getInstances() {
            return this.instances;
        }

        @DataBoundSetter
        public void setInstances(String instances) {
            this.instances = instances;
        }

        public String getTimeout() {
            return this.timeout;
        }

        @DataBoundSetter
        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public String isNoRoute() {
            return this.noRoute;
        }

        @DataBoundSetter
        public void setNoRoute(String noRoute) {
            this.noRoute = noRoute;
        }

        public String getAppPath() {
            return this.appPath;
        }

        @DataBoundSetter
        public void setAppPath(String appPath) {
            this.appPath = appPath;
        }

        public String getBuildpack() {
            return this.buildpack;
        }

        @DataBoundSetter
        public void setBuildpack(String buildpack) {
            this.buildpack = buildpack;
        }

        public String getStack() {
            return this.stack;
        }

        @DataBoundSetter
        public void setStack(String stack) {
            this.stack = stack;
        }

        public String getCommand() {
            return this.command;
        }

        @DataBoundSetter
        public void setCommand(String command) {
            this.command = command;
        }

        public String getDomain() {
            return this.domain;
        }

        @DataBoundSetter
        public void setDomain(String domain) {
            this.domain = domain;
        }

        public List<EnvironmentVariable> getEnvVars() {
            return this.envVars;
        }

        @DataBoundSetter
        public void setEnvVars(List<EnvironmentVariable> envVars) {
            this.envVars = envVars;
        }

        public List<ServiceName> getServicesNames() {
            return this.servicesNames;
        }

        @DataBoundSetter
        public void setServicesNames(List<ServiceName> servicesNames) {
            this.servicesNames = servicesNames;
        }

        public static ManifestChoice defaultManifestFileConfig() {
            return new ManifestChoice();
        }
    }
}

