/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.cloudfoundryjenkins;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.hpe.cloudfoundryjenkins.CloudFoundryUtils;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractCloudFoundryPushDescriptor<T extends BuildStep & Describable<T>>
extends BuildStepDescriptor<T> {
    public static final int DEFAULT_MEMORY = 512;
    public static final int DEFAULT_INSTANCES = 1;
    public static final int DEFAULT_TIMEOUT = 60;
    public static final String DEFAULT_STACK = null;

    protected AbstractCloudFoundryPushDescriptor(Class<? extends T> clazz) {
        super(clazz);
    }

    protected AbstractCloudFoundryPushDescriptor() {
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "Push to Cloud Foundry";
    }

    public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter(value="target") String target) {
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        result.includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernamePasswordCredentials.class, URIRequirementBuilder.fromUri((String)target).build(), CredentialsMatchers.always());
        return result;
    }

    public FormValidation doTestConnection(@AncestorInPath ItemGroup context, @QueryParameter(value="target") String target, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="organization") String organization, @QueryParameter(value="cloudSpace") String cloudSpace, @QueryParameter(value="selfSigned") String selfSigned) {
        return CloudFoundryUtils.doTestConnection(context, target, credentialsId, organization, cloudSpace, selfSigned);
    }

    public FormValidation doCheckTarget(@QueryParameter String value) {
        if (!value.isEmpty()) {
            try {
                if (value.startsWith("http://") || value.startsWith("https://")) {
                    new URL(value);
                } else {
                    new URL("https://" + value);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"Malformed URL");
            }
        }
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckCredentialsId(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckOrganization(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckCloudSpace(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckPluginTimeout(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doCheckMemory(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doCheckInstances(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doCheckTimeout(@QueryParameter String value) {
        return FormValidation.validatePositiveInteger((String)value);
    }

    public FormValidation doCheckAppName(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }

    public FormValidation doCheckHostname(@QueryParameter String value) {
        return FormValidation.validateRequired((String)value);
    }
}

