/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.EventOutputStreams;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.jcraft.jzlib.GZIPInputStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.BulkChange;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.console.AnnotatedLargeText;
import hudson.console.PlainTextConsoleOutputStream;
import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Executor;
import hudson.model.Items;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Saveable;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.listeners.SaveableListener;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.HttpResponses;
import hudson.util.StreamTaskListener;
import hudson.util.io.RewindableRotatingFileOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class FolderComputation<I extends TopLevelItem>
extends Actionable
implements Queue.Executable,
Saveable {
    private static final Logger LOGGER = Logger.getLogger(FolderComputation.class.getName());
    @CheckForNull
    private static Integer BACKUP_LOG_COUNT = Integer.getInteger(FolderComputation.class.getName() + ".BACKUP_LOG_COUNT");
    @NonNull
    private static int EVENT_LOG_MAX_SIZE = Math.max(1, Integer.getInteger(FolderComputation.class.getName() + ".EVENT_LOG_MAX_SIZE", 150));
    @NonNull
    private final transient ComputedFolder<I> folder;
    @CheckForNull
    private final transient Result previousResult;
    @GuardedBy(value="this")
    @CheckForNull
    private transient EventOutputStreams eventStreams;
    @CheckForNull
    private volatile Result result;
    @CheckForNull
    private List<Long> durations;
    private long timestamp;
    private long duration;
    public static final AlternativeUiTextProvider.Message<FolderComputation> DISPLAY_NAME;

    protected FolderComputation(@NonNull ComputedFolder<I> folder, @CheckForNull FolderComputation<I> previous) {
        this.folder = folder;
        this.previousResult = previous == null ? null : previous.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamBuildListener listener;
        try {
            FileOutputStream os;
            File logFile = this.getLogFile();
            FileUtils.forceMkdir((File)logFile.getParentFile());
            if (BACKUP_LOG_COUNT != null) {
                os = new RewindableRotatingFileOutputStream(logFile, BACKUP_LOG_COUNT.intValue());
                ((RewindableRotatingFileOutputStream)os).rewind();
            } else {
                os = new FileOutputStream(logFile);
            }
            listener = new StreamBuildListener((OutputStream)os, StandardCharsets.UTF_8);
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
            this.result = Result.FAILURE;
            return;
        }
        this.timestamp = System.currentTimeMillis();
        listener.started(this.getCauses());
        Result _result = Result.NOT_BUILT;
        try {
            this.folder.updateChildren((TaskListener)listener);
            _result = Result.SUCCESS;
        }
        catch (InterruptedException x) {
            LOGGER.log(Level.FINE, "recomputation of " + this.folder.getFullName() + " was aborted", x);
            listener.getLogger().println("Aborted");
            _result = Result.ABORTED;
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, "recomputation of " + this.folder.getFullName() + " failed", x);
            if (x instanceof AbortException) {
                listener.fatalError(x.getMessage());
            } else {
                Functions.printStackTrace((Throwable)x, (PrintWriter)listener.fatalError("Failed to recompute children of " + this.folder.getFullDisplayName()));
            }
            _result = Result.FAILURE;
        }
        finally {
            this.duration = System.currentTimeMillis() - this.timestamp;
            if (this.durations == null) {
                this.durations = new ArrayList<Long>();
            }
            while (this.durations.size() > 32) {
                this.durations.remove(0);
            }
            this.durations.add(this.duration);
            listener.finished(_result);
            listener.closeQuietly();
            this.result = _result;
            try {
                this.save();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        XmlFile dataFile = this.getDataFile();
        dataFile.write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)dataFile);
    }

    @NonNull
    public File getLogFile() {
        return new File(this.folder.getComputationDir(), "computation.log");
    }

    @NonNull
    public File getEventsFile() {
        return new File(this.folder.getComputationDir(), "events.log");
    }

    @WithBridgeMethods(value={TaskListener.class})
    @NonNull
    public synchronized StreamTaskListener createEventsListener() {
        File eventsFile = this.getEventsFile();
        if (!eventsFile.getParentFile().isDirectory() && !eventsFile.getParentFile().mkdirs()) {
            LOGGER.log(Level.WARNING, "Could not create directory {0} for {1}", new Object[]{eventsFile.getParentFile(), this.folder.getFullName()});
        }
        if (this.eventStreams == null) {
            this.eventStreams = new EventOutputStreams(new EventOutputStreams.OutputFile(){

                @Override
                @NonNull
                public File get() {
                    return FolderComputation.this.getEventsFile();
                }

                @Override
                public boolean canWriteNow() {
                    GregorianCalendar timestamp = new GregorianCalendar();
                    timestamp.setTimeInMillis(System.currentTimeMillis() - 10000L);
                    Queue.WaitingItem probe = new Queue.WaitingItem((Calendar)timestamp, (Queue.Task)FolderComputation.this.folder, Collections.emptyList());
                    for (QueueTaskDispatcher d : QueueTaskDispatcher.all()) {
                        if (d.canRun((Queue.Item)probe) == null) continue;
                        return false;
                    }
                    return true;
                }
            }, 250L, TimeUnit.MILLISECONDS, 1024, true, EVENT_LOG_MAX_SIZE * 1024, BACKUP_LOG_COUNT == null ? 0 : Math.max(0, BACKUP_LOG_COUNT));
        }
        return new StreamTaskListener(this.eventStreams.get(), StandardCharsets.UTF_8);
    }

    @NonNull
    protected XmlFile getDataFile() {
        return new XmlFile(Items.XSTREAM, new File(this.folder.getComputationDir(), "computation.xml"));
    }

    public List<Cause> getCauses() {
        CauseAction a = (CauseAction)this.getAction(CauseAction.class);
        if (a == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(a.getCauses());
    }

    public String getDisplayName() {
        return AlternativeUiTextProvider.get(DISPLAY_NAME, (Object)((Object)this), (String)Messages.FolderComputation_DisplayName());
    }

    public String getSearchUrl() {
        return "computation/";
    }

    @NonNull
    public ComputedFolder<I> getParent() {
        return this.folder;
    }

    public long getEstimatedDuration() {
        if (this.durations == null || this.durations.isEmpty()) {
            return -1L;
        }
        long total = 0L;
        for (Long d : this.durations) {
            total += d.longValue();
        }
        return total / (long)this.durations.size();
    }

    public boolean isBuilding() {
        return Executor.of((Queue.Executable)this) != null;
    }

    public boolean isLogUpdated() {
        return this.result == null;
    }

    @NonNull
    public AnnotatedLargeText<FolderComputation<I>> getLogText() {
        return new AnnotatedLargeText(this.getLogFile(), StandardCharsets.UTF_8, !this.isLogUpdated(), (Object)this);
    }

    @NonNull
    public AnnotatedLargeText<FolderComputation<I>> getEventsText() {
        File eventsFile = this.getEventsFile();
        if (eventsFile.length() <= 0L) {
            ByteBuffer buffer = new ByteBuffer();
            try {
                buffer.write(String.format("No events as of %tc, waiting for events...%n", new Date()).getBytes(StandardCharsets.UTF_8));
                return new AnnotatedLargeText(buffer, StandardCharsets.UTF_8, false, (Object)this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new AnnotatedLargeText(eventsFile, StandardCharsets.UTF_8, false, (Object)this);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Only one page is ever written here")
    public void writeLogTo(long offset, XMLOutput out) throws IOException {
        this.getLogText().writeHtmlTo(offset, out.asWriter());
    }

    public void writeWholeLogTo(@NonNull OutputStream out) throws IOException, InterruptedException {
        AnnotatedLargeText<FolderComputation<I>> logText;
        long pos = 0L;
        do {
            logText = this.getLogText();
            pos = logText.writeLogTo(pos, out);
        } while (!logText.isComplete());
    }

    public void doConsoleText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.setContentType("text/plain;charset=UTF-8");
        try (PlainTextConsoleOutputStream out = new PlainTextConsoleOutputStream(rsp.getCompressedOutputStream((HttpServletRequest)req));
             InputStream input = this.getLogInputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)out);
            out.flush();
        }
    }

    @RequirePOST
    public synchronized HttpResponse doStop() throws IOException, ServletException {
        Executor e = Executor.of((Queue.Executable)this);
        if (e != null) {
            return e.doStop();
        }
        return HttpResponses.forwardToPreviousPage();
    }

    @NonNull
    public InputStream getLogInputStream() throws IOException {
        File logFile = this.getLogFile();
        if (logFile.exists()) {
            FileInputStream fis = new FileInputStream(logFile);
            if (logFile.getName().endsWith(".gz")) {
                return new GZIPInputStream((InputStream)fis);
            }
            return fis;
        }
        String message = "No such file: " + logFile;
        return new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
    }

    @CheckForNull
    public Result getResult() {
        return this.result;
    }

    @NonNull
    public Calendar getTimestamp() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(this.timestamp);
        return c;
    }

    @NonNull
    public String getDurationString() {
        if (this.isBuilding()) {
            return Messages.Run_InProgressDuration(Util.getTimeSpanString((long)(System.currentTimeMillis() - this.timestamp)));
        }
        return Util.getTimeSpanString((long)this.duration);
    }

    @NonNull
    public String getUrl() {
        return this.folder.getUrl() + "computation/";
    }

    @CheckForNull
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @NonNull
    public BallColor getIconColor() {
        Result _result = this.result;
        if (_result != null) {
            return _result.color;
        }
        Result previousResult = this.getPreviousResult();
        if (previousResult == null) {
            return this.isBuilding() ? BallColor.NOTBUILT_ANIME : BallColor.NOTBUILT;
        }
        return this.isBuilding() ? previousResult.color.anime() : previousResult.color;
    }

    public String getBuildStatusIconClassName() {
        return this.getIconColor().getIconClassName();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.folder.getFullName() + "]";
    }

    static {
        Items.XSTREAM.alias("folder-computation", FolderComputation.class);
        DISPLAY_NAME = new AlternativeUiTextProvider.Message();
    }
}

