/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.webdav;

import com.github.sardine.SardineFactory;
import com.github.sardine.impl.SardineImpl;
import hudson.FilePath;
import hudson.plugins.backlog.Messages;
import hudson.plugins.backlog.webdav.FilePathEntity;
import java.io.IOException;
import org.apache.http.HttpEntity;

public class WebdavClient {
    private final SardineImpl sardine;
    private final String url;
    private String removePrefix = "";

    public WebdavClient(String url, String username, String password) {
        this.url = url;
        this.sardine = (SardineImpl)SardineFactory.begin((String)username, (String)password);
        try {
            this.sardine.list(url);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed login to Backlog", e);
        }
    }

    public void put(FilePath filePath, String remotePath) throws IOException {
        FilePathEntity entity = new FilePathEntity(filePath, "application/octet-stream");
        this.sardine.put(this.url + remotePath + filePath.getName(), (HttpEntity)entity, "application/octet-stream", true);
    }

    public void putWithParent(FilePath filePath, String remotePath, FilePath basePath) throws IOException, InterruptedException {
        String directory = this.normalizeDirectory(remotePath);
        this.createDirectoriesRecursive("", directory);
        this.createDirectoriesFromBase(filePath.getParent(), directory, basePath);
        this.put(filePath, directory + this.getPathFromBase(filePath.getParent(), basePath));
    }

    public boolean delete(String remotePath) throws IOException {
        String deleteUrl = this.url + this.normalizeDirectory(remotePath);
        if (this.sardine.exists(deleteUrl)) {
            this.sardine.delete(deleteUrl);
            return true;
        }
        return false;
    }

    void createDirectory(String remotePath) throws IOException {
        String createUrl = this.normalizeDirectory(this.url + remotePath);
        if (!this.sardine.exists(createUrl)) {
            this.sardine.createDirectory(createUrl);
        }
    }

    void createDirectoriesFromBase(FilePath filePath, String remotePath, FilePath basePath) throws IOException, InterruptedException {
        this.createDirectoriesRecursive(remotePath, this.getPathFromBase(filePath, basePath));
    }

    void createDirectoriesRecursive(String base, String path) throws IOException {
        String parent = this.normalizeDirectory(base);
        this.createDirectory(parent);
        for (String splitPath : path.split("/")) {
            parent = this.normalizeDirectory(parent + splitPath);
            this.createDirectory(parent);
        }
    }

    String getPathFromBase(FilePath filePath, FilePath basePath) throws IOException, InterruptedException {
        String baseString;
        String pathString = filePath.toURI().normalize().getPath();
        String pathFromBase = pathString.substring((baseString = basePath.toURI().normalize().getPath()).length());
        if (!pathFromBase.startsWith(this.normalizeDirectory(this.removePrefix))) {
            throw new IllegalArgumentException(Messages.BacklogWebdavPublisher_ErrorNotStartedPrefix(pathFromBase, this.removePrefix));
        }
        return pathFromBase.substring(this.normalizeDirectory(this.removePrefix).length());
    }

    String normalizeDirectory(String directory) {
        if (directory.isEmpty()) {
            return directory;
        }
        String result = directory.startsWith("/") ? directory.substring(1) : directory;
        if (!directory.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public String getRemovePrefix() {
        return this.removePrefix;
    }

    public void setRemovePrefix(String removePrefix) {
        this.removePrefix = removePrefix;
    }
}

