/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.backlog.Messages;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.dao.DataAccessException;

public class BacklogSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final String LOGIN_ENDPOINT = "ical/myissues.ics";
    private static final Log LOG = LogFactory.getLog(BacklogSecurityRealm.class);
    public final String url;

    @DataBoundConstructor
    public BacklogSecurityRealm(String url) {
        this.url = StringUtils.isNotEmpty((String)url) ? (url.endsWith("/") ? url : url + '/') : null;
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        try {
            if (this.canLogin(username, password)) {
                return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
            }
            throw new BadCredentialsException("Failed to login as " + username);
        }
        catch (IOException e) {
            throw new BadCredentialsException("Failed to login as " + username, (Throwable)e);
        }
    }

    private boolean canLogin(String username, String password) throws IOException {
        HttpGet httpGet = new HttpGet(this.url + LOGIN_ENDPOINT);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(httpGet.getURI().getHost(), httpGet.getURI().getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
            EntityUtils.consume((HttpEntity)response.getEntity());
            boolean bl = response.getStatusLine().getStatusCode() == 200;
            return bl;
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        LOG.info((Object)("Backlog Security Realm always returns the specified user : '" + username + "'"));
        return new User(username, "", true, true, true, true, new GrantedAuthority[]{AUTHENTICATED_AUTHORITY});
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        LOG.warn((Object)("Backlog Security Realm doesn't support groups : '" + groupname + "'"));
        throw new UsernameNotFoundException(groupname);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Backlog";
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.BacklogSecurityRealm_Url_Error());
            }
            return FormValidation.ok();
        }
    }
}

