/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.MarkupText;
import hudson.model.Run;
import hudson.plugins.backlog.BacklogProjectProperty;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Extension
public class BacklogChangelogAnnotator
extends ChangeLogAnnotator {
    private static final Log LOG = LogFactory.getLog(BacklogChangelogAnnotator.class);
    public static final Pattern ISSUE_KEY_PATTERN = Pattern.compile("(?:(?<![/A-Z0-9a-z-_])([A-Z0-9_]+-[1-9][0-9]*)|\\[\\[([A-Z0-9_]+-[1-9][0-9]*)\\]\\])");

    public void annotate(Run<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        BacklogProjectProperty bpp = (BacklogProjectProperty)build.getParent().getProperty(BacklogProjectProperty.class);
        if (bpp == null || bpp.getSpaceURL() == null) {
            LOG.warn((Object)"BacklogProjectProperty is null or BacklogProjectProperty's spaceURL is null");
            return;
        }
        this.annotate(bpp.getSpaceURL(), text);
    }

    void annotate(String spaceURL, MarkupText text) {
        Matcher m = ISSUE_KEY_PATTERN.matcher(text.getText());
        ArrayList<MarkupText.SubText> r = new ArrayList<MarkupText.SubText>();
        while (m.find()) {
            MarkupText markupText = text;
            markupText.getClass();
            MarkupText.SubText st = new MarkupText.SubText(markupText, m, 0);
            r.add(st);
        }
        for (MarkupText.SubText token : r) {
            LOG.debug((Object)("token=" + token.getText()));
            token.surroundWith("<a href=\"" + spaceURL + "view/$1$2\">", "</a>");
        }
    }
}

