/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla.api;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlDataParser
extends DefaultHandler2 {
    protected InputStream instream;
    protected SAXParser parser;
    protected StringBuilder currentReadCharacters;
    private static SAXParserFactory parserFactoryInstance;

    protected abstract void startElement(String var1);

    protected abstract void endElement(String var1, String var2);

    private static SAXParserFactory getParserFactoryInstance() {
        if (parserFactoryInstance == null) {
            parserFactoryInstance = SAXParserFactory.newInstance();
            parserFactoryInstance.setValidating(false);
        }
        return parserFactoryInstance;
    }

    public XmlDataParser(InputStream instream) {
        this.instream = instream;
    }

    public void setInstream(InputStream instream) {
        this.instream = instream;
    }

    public void start() throws IOException, SAXException, ParserConfigurationException {
        this.parser = XmlDataParser.getParserFactoryInstance().newSAXParser();
        this.parser.parse(this.instream, (DefaultHandler)this);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.currentReadCharacters = new StringBuilder();
        String elementName = null;
        elementName = qName.length() == 0 ? localName : qName;
        this.startElement(elementName);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        String elementName = null;
        elementName = qName.length() == 0 ? localName : qName;
        if (this.currentReadCharacters != null) {
            this.endElement(elementName, this.currentReadCharacters.toString());
        } else {
            this.endElement(elementName, "");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.currentReadCharacters == null) {
            this.currentReadCharacters = new StringBuilder();
        }
        for (int i = start; i < start + length; ++i) {
            this.currentReadCharacters.append(ch[i]);
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }
}

