/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.assembla;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.plugin.assembla.AssemblaPlugin;
import jenkins.plugin.assembla.Messages;
import jenkins.plugin.assembla.api.AssemblaHttpClient;
import jenkins.plugin.assembla.api.AssemblaSite;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblaProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(AssemblaProjectProperty.class.getName());
    private String spaceName;
    private boolean backtrackEnabled;
    private String siteName;
    private boolean pluginEnabled;

    @DataBoundConstructor
    public AssemblaProjectProperty(String spaceName, boolean backtrackEnabled, String siteName, boolean pluginEnabled) {
        LOGGER.info("AssemblaProjectProperty created");
        LOGGER.info("spaceName=" + spaceName);
        LOGGER.info("backtrackEnabled=" + backtrackEnabled);
        LOGGER.info("siteName=" + siteName);
        LOGGER.info("pluginEnabled=" + pluginEnabled);
        this.siteName = siteName;
        this.spaceName = spaceName;
        this.backtrackEnabled = backtrackEnabled;
        this.pluginEnabled = pluginEnabled;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public boolean isBacktrackEnabled() {
        return this.backtrackEnabled;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public AssemblaSite getSite() {
        AssemblaSite result = null;
        AssemblaSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            result = sites[0];
        }
        for (AssemblaSite site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            result = site;
            break;
        }
        if (result != null) {
            result.setSpace(this.spaceName);
            result.setBacktrackEnabled(this.backtrackEnabled);
            result.setPluginEnabled(this.pluginEnabled);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<AssemblaSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(AssemblaProjectProperty.class);
            this.load();
        }

        public void setSites(AssemblaSite site) {
            this.sites.add((Object)site);
        }

        public AssemblaSite[] getSites() {
            AssemblaSite[] result = (AssemblaSite[])this.sites.toArray((Object[])new AssemblaSite[0]);
            LOGGER.info("Called getSites size=" + result.length);
            return result;
        }

        public String getDisplayName() {
            return "Assembla Plugin";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            LOGGER.info("DescriptorImpl newInstance called");
            AssemblaProjectProperty jpp = (AssemblaProjectProperty)((Object)req.bindParameters(AssemblaProjectProperty.class, "assembla."));
            if (jpp.siteName == null) {
                jpp = null;
            }
            return jpp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            LOGGER.info("DescriptorImpl configure called");
            this.sites.replaceBy((Collection)req.bindParametersToList(AssemblaSite.class, "assembla."));
            this.save();
            LOGGER.info("sites.size()=" + this.sites.size());
            return true;
        }

        public FormValidation doUrlCheck(final @QueryParameter String value) throws IOException, ServletException {
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)value);
                    if (url == null) {
                        return FormValidation.error((String)Messages.AssemblaProjectProperty_AssemblaUrlMandatory());
                    }
                    return FormValidation.ok();
                }
            }.check();
        }

        public FormValidation doTestConnection(@QueryParameter(value="assembla.url") String url, @QueryParameter(value="assembla.username") String username, @QueryParameter(value="assembla.password") String password) throws IOException, ServletException {
            try {
                AssemblaSite site = new AssemblaSite(username, password, url, null);
                AssemblaHttpClient client = new AssemblaHttpClient(site);
                int serverError = client.executeHttpGet("my_spaces", null);
                if (serverError == 200) {
                    return FormValidation.okWithMarkup((String)("<img style='margin: -2px 4px 0px 0px;' src='" + AssemblaPlugin.getResourcePath("button-check.png") + "'/><font color='#008000'><b>Success</b></font>"));
                }
                return FormValidation.error((String)("Cannot connect to '" + url + "': server error[" + serverError + "]"));
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }
    }
}

