/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.assembla.cause;

import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.assembla.WebhookPayload;
import org.jenkinsci.plugins.assembla.api.models.MergeRequest;
import org.jenkinsci.plugins.assembla.api.models.SpaceTool;
import org.jenkinsci.plugins.assembla.cause.AssemblaCause;

public class AssemblaMergeRequestCause
extends AssemblaCause {
    private final Integer mergeRequestId;
    private final String targetBranch;
    private final String targetRepositoryUrl;
    private final String action;

    public Integer getMergeRequestId() {
        return this.mergeRequestId;
    }

    public String getTargetBranch() {
        return this.targetBranch;
    }

    public AssemblaMergeRequestCause(Integer mergeRequestId, String sourceRepositoryUrl, String sourceRepositoryName, String sourceBranch, String targetRepositoryUrl, String targetBranch, String commitId, String description, String sourceSpaceId, String title, String author, String action) {
        super(sourceRepositoryUrl, sourceRepositoryName, sourceBranch, commitId, title, description, sourceSpaceId, author);
        this.targetBranch = targetBranch;
        this.mergeRequestId = mergeRequestId;
        this.targetRepositoryUrl = targetRepositoryUrl;
        this.action = action;
    }

    public String getAbbreviatedTitle() {
        return StringUtils.abbreviate((String)this.getTitle(), (int)30);
    }

    public String getTargetRepositoryUrl() {
        return this.targetRepositoryUrl;
    }

    public Boolean isCreated() {
        return this.action.equals("created");
    }

    public Boolean isUpdated() {
        return this.action.equals("updated") || this.action.equals("reopened");
    }

    public Boolean isMerged() {
        return this.action.equals("merged");
    }

    public Boolean isIgnored() {
        return this.action.equals("ignored");
    }

    public String getShortDescription() {
        if (this.isFromFork()) {
            return String.format("Assembla Merge Request #%s: %s - %s/%s => %s/%s", this.getMergeRequestId(), this.getAbbreviatedTitle(), this.getSourceRepositoryUrl(), this.getSourceBranch(), this.getTargetRepositoryUrl(), this.getTargetBranch());
        }
        return String.format("Assembla Merge Request #%s: %s - %s/%s => %s", this.getMergeRequestId(), this.getAbbreviatedTitle(), this.getSourceRepositoryUrl(), this.getSourceBranch(), this.getTargetBranch());
    }

    public static AssemblaMergeRequestCause fromMergeRequest(MergeRequest mr, SpaceTool sourceTool, SpaceTool targetTool, WebhookPayload payload) {
        return new AssemblaMergeRequestCause(mr.getId(), sourceTool.getUrl(), sourceTool.getName(), mr.getSourceSymbol(), targetTool.getUrl(), mr.getTargetSymbol(), payload.getCommitId(), mr.getDescription(), mr.getTargetSpaceId(), mr.getTitle(), payload.getAuthor(), payload.getAction());
    }

    public boolean isFromFork() {
        return !this.getSourceRepositoryUrl().equals(this.getTargetRepositoryUrl());
    }
}

