/*
 * Decompiled with CFR 0.152.
 */
package com.assembla.jenkinsci.plugin;

import com.assembla.jenkinsci.plugin.AssemblaAuthenticationToken;
import com.assembla.jenkinsci.plugin.api.ApiService;
import com.assembla.jenkinsci.plugin.api.AssemblaPermission;
import com.assembla.jenkinsci.plugin.api.SpaceAssembla;
import com.assembla.jenkinsci.plugin.api.UserRoleAssembla;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.Authentication;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class AssemblaACL
extends ACL {
    private static final Logger LOG = Logger.getLogger(AssemblaACL.class.getName());
    private static final long USER_API_CALL_CACHE_TIME = 300000L;
    private final List<String> adminUserNameList;

    public AssemblaACL(String adminUserNames) {
        String[] parts;
        LOG.fine("**************** AssemblaACL() ****************");
        this.adminUserNameList = new LinkedList<String>();
        for (String part : parts = adminUserNames.split(",")) {
            this.adminUserNameList.add(part.trim());
        }
    }

    public boolean hasPermission(Authentication a, Permission permission) {
        boolean result;
        block8: {
            String authenticatedUserName;
            block9: {
                block7: {
                    result = false;
                    authenticatedUserName = a.getName();
                    if (!this.adminUserNameList.contains(authenticatedUserName)) break block7;
                    result = true;
                    break block8;
                }
                if (!(a instanceof AssemblaAuthenticationToken)) break block9;
                AssemblaAuthenticationToken aat = (AssemblaAuthenticationToken)a;
                int assemblaPermission = this.getAssemblaPermissionFromAPI(aat);
                switch (assemblaPermission) {
                    case 3: {
                        result = true;
                        break;
                    }
                    case 2: {
                        result = true;
                        if (permission.getId().equals("hudson.model.Hudson.Administer")) {
                            result = false;
                            break;
                        }
                        break block8;
                    }
                    case 1: {
                        result = this.isReadPermission(permission);
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
                break block8;
            }
            if (a instanceof UsernamePasswordAuthenticationToken && authenticatedUserName.equals(SYSTEM.getPrincipal())) {
                result = true;
            }
        }
        return result;
    }

    private int getAssemblaPermissionFromAPI(AssemblaAuthenticationToken aat) {
        Calendar currentCal = Calendar.getInstance();
        if (currentCal.getTimeInMillis() - aat.getLastTimeApiCall() > 300000L) {
            LOG.fine("getAssemblaPermissionFromAPI() - - Reloading user data from Assembla API ...");
            aat.getUser().setRole(null);
            try {
                String access_token;
                aat.getTokensAssembla().access_token = access_token = ApiService.postRefreshAccessToken(aat.getTokensAssembla().refresh_token, aat.getTokensAssembla().clientId, aat.getTokensAssembla().clientSecret);
                SpaceAssembla space = ApiService.getSpace(aat.getTokensAssembla().access_token, aat.getUser().getSpaceId());
                UserRoleAssembla[] userRoles = ApiService.getUserRoles(aat.getTokensAssembla().access_token, aat.getUser().getSpaceId());
                if (userRoles != null) {
                    for (UserRoleAssembla ur : userRoles) {
                        if (!aat.getUser().id.equals(ur.getUserId())) continue;
                        aat.getUser().setRole(ur.getRole());
                        break;
                    }
                }
                aat.getUser().setAssembla_permission(AssemblaPermission.getPermission(aat.getUser().getRole(), space));
                aat.setLastTimeApiCall(currentCal.getTimeInMillis());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "getAssemblaPermissionFromAPI()", e);
                aat.getUser().setAssembla_permission(0);
            }
        }
        return aat.getUser().getAssembla_permission();
    }

    private boolean isReadPermission(Permission permission) {
        return permission.getId().equals("hudson.model.Hudson.Read") || permission.getId().equals("hudson.model.Item.Read");
    }

    public List<String> getAdminUserNameList() {
        return this.adminUserNameList;
    }
}

