/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.commons.lang.StringUtils;

public class SigningComponents
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final PrivateKey key;
    public final Certificate[] certChain;
    public final String alias;
    public final String v1SigName;

    public static SigningComponents fromCredentials(StandardCertificateCredentials creds, String keyAlias) throws GeneralSecurityException {
        KeyStore.PrivateKeyEntry entry;
        KeyStore keyStore = creds.getKeyStore();
        if (StringUtils.isEmpty((String)keyAlias)) {
            keyAlias = null;
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases != null) {
                while (aliases.hasMoreElements()) {
                    String entryAlias = aliases.nextElement();
                    if (!keyStore.isKeyEntry(entryAlias)) continue;
                    if (keyAlias != null) {
                        throw new UnrecoverableKeyException("no key alias was given and there is more than one entry in key store");
                    }
                    keyAlias = entryAlias;
                }
            }
        }
        if (keyAlias == null) {
            throw new UnrecoverableKeyException("no key alias was given and no key entries were found in key store");
        }
        String password = creds.getPassword().getPlainText();
        char[] passwordChars = new char[]{};
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(passwordChars);
        try {
            entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(keyAlias, protection);
        }
        catch (NullPointerException e) {
            if (StringUtils.isEmpty((String)password)) {
                throw new NullKeyStorePasswordException("the password for key store credential " + creds.getId() + " is null - use the Credentials Plugin to configure a non-empty password", e);
            }
            throw e;
        }
        if (entry == null) {
            throw new GeneralSecurityException("key store credential " + creds.getId() + " has no entry named " + keyAlias);
        }
        PrivateKey key = entry.getPrivateKey();
        Certificate[] certChain = entry.getCertificateChain();
        return new SigningComponents(key, certChain, keyAlias, keyAlias);
    }

    private SigningComponents(PrivateKey key, Certificate[] certChain, String alias, String v1SigName) {
        this.key = key;
        this.certChain = certChain;
        this.alias = alias;
        this.v1SigName = v1SigName;
    }

    static class NullKeyStorePasswordException
    extends GeneralSecurityException {
        NullKeyStorePasswordException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

